<?php
use Endroid\Twitter\Twitter;

App::uses('CakeText', 'Utility');

class TwitterHandler {

	/**
	 * Sends a message out to twitter via the api.
	 * @param  integer $id id of the message to send out
	 * @return void
	 */
	public function sendMesssage($id) {
		// load the message from the db
		$Message = EvClassRegistry::init('EvSocialSchedule.Message');
		$message = $Message->find('first', [
			'conditions' => [
				'Message.id' => $id
			],
			'contain' => [
				'SocialNetworkAccount' => [
					'conditions' => [
						'SocialNetworkAccount.handler' => 'twitter'
					]
				]
			]
		]);

		if (! empty($message)) {
			if (isset($message['SocialNetworkAccount']) && ! empty($message['SocialNetworkAccount'])) {

				// Load in cakes text util so we can truncate the string (twitter will refuse to accept it without this being done)
				$CakeText = new CakeText();

				foreach ($message['SocialNetworkAccount'] as $account) {
					$accountData = json_decode($account['data']);
					$twitter = new Twitter($accountData->consumerKey, $accountData->consumerSecret, $accountData->accessToken, $accountData->accessTokenSecret);

					// Send the post - trunated to 137 chars to allow for '...' taking it up to 140.
					$sendPost = $twitter->query('statuses/update', 'POST', 'json', [
						'status' => $CakeText->truncate($message['Message']['text'], 137)
					]);
				}
			}
		}
	}
}
