<?php

class MessagesController extends AppController {

	/**
	 * update form fields to remove some fields we don't want people to edit, and tweak the format
	 * of other fields.
	 * @return array returns the array of field data.
	 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['SocialNetworkAccount'] = array(
			'type' => 'multicheck',
			'label' => 'Social Network accounts to publish to.'
		);

		$fields['Message.text']['type'] = 'text_plain';
		$fields['Message.text']['displayInfo'] = 'Note that some social networks (e.g Twitter) have a character limit. If your message goes over that limit, it will be automatically truncated.';
		$fields['Message.queued_task_id']['type'] = 'hidden';

		$fields['Message.publish_date']['label'] = 'Publish Date';

		unset($fields['Message.sent']);
		$fields['Message.id']['type'] = 'hidden';

		return $fields;
	}

	/**
	 * populate lookups with social accounts
	 * @return void
	 */
	protected function _adminPopulateLookups() {
		$this->loadModel('EvSocialSchedule.SocialNetworkAccount');
		$this->set('socialNetworkAccounts', $this->SocialNetworkAccount->find('list'));
	}

	/**
	 * modify admin_edit to redirect already sent messages to the view to avoid them being edited.
	 * @param  boolean $id id of the message to edit
	 * @return mixed returns the admin_edit form or redirects to admin_view
	 */
	public function admin_edit($id = null) {
		parent::admin_edit($id);

		if ($id > 0 && isset($this->request->data['Message']['sent']) && $this->request->data['Message']['sent'] != '') {
			return $this->redirect(array(
				'plugin' => 'ev_social_schedule',
				'admin' => true,
				'controller' => 'messages',
				'action' => 'view',
				$this->request->data['Message']['id']
			));
		}
	}
}
