<?php

App::uses('QueueTask', 'Queue.Console/Command/Task');

class QueueSocialScheduleTask extends QueueTask {

	public function add() {
		$this->err('Queue Social Schedule Task cannot be added via Console.');
	}

	/**
	 * QueueSocialScheduleTask::run()
	 *
	 * @param mixed $data Job data
	 * @param int $id The id of the QueuedTask
	 * @return bool Success
	 */
	public function run($data, $id = null) {
		$Message = EvClassRegistry::init('EvSocialSchedule.Message');
		$message = $Message->find('first', [
			'conditions' => [
				'Message.id' => $data['id']
			],
			'contain' => ['SocialNetworkAccount']
		]);

		if (! empty($message)) {

			if (isset($message['SocialNetworkAccount']) && ! empty($message['SocialNetworkAccount'])) {
				foreach ($message['SocialNetworkAccount'] as $account) {
					$accountParams = json_decode($account['data']);

					// Work out the handler
					$handlerName = $account['handler'] . 'Handler';

					// Load the handler and hand the sending over to it.
					App::uses($handlerName, 'EvSocialSchedule.Lib');
					$handler = new $handlerName();
					$handler->sendMesssage($message['Message']['id']);
				}
			}

			// Set the message as sent.
			$now = new DateTime();

			$message['Message']['sent'] = $now->format('Y-m-d H:i:s');
			$Message->save($message);
		}

		return true;
	}

}

