# EvSlugabble

Sluggable behaviour which can be used as an alternative to the Routable behaviour

## Installation

The plugin can be installed via Composer by running `composer require evoluted/sluggable`

## Usage

Define the behaviour in each required model, defining the database field to used to store the item slug (`url_slug` in this example)

    public $actsAs = array(
        ...
        'EvSluggable.Slugged' => [
            'slugField' => 'url_slug',
            'routeParams' => [
                'ref' => ':ref',
                'url_slug' => ':slug'
            ]
        ]
        ...
    );

The `slugField` string will be automatically be created by the behaviour based upon the model's `displayField` value. This can be overriden by supplying a `label` value through the behaviour settings.

The `routeParams` array can be overridden to pass through placeholders `alias` placeholders as we currently do in the app `routes.php` file. 

The behaviour will assign the slug string to each field in the model data set through the `afterFind` callback.

Once the model has been setup, you can run `Console/cake EvSluggable.PopulateSlugField EvShop.Product` or the full name
of your model to populate the slug field.

Setup the route in your routes.php to be however you desire ensuring that the slug is passed through the route as below
```
Router::connect(
	'/products/:slug',
	array(
		'plugin' => false,
		'controller' => 'ev_shop_products',
		'action' => 'view'
	),
	array(
		'slug' => '[\w\-]+',
		'pass' => [
			'slug'
		]
	)
);
```

Then pass in the config
```
['key' => 'slugFieldName']
```
in the query parameter of the readForView replacing slugFieldName with the name of the field that you're treating as the
slug.
