EvSitemap
==============

Introduction
--------------

Super simple Sitemap generating CakePHP plugin.

**Converted to Composer, June 2015**


Features
--------------

* Takes advantage of the CakePHP model behaviour allowing Sitemaps to be created for any model within your CakePHP project.

* Allows you to be able to upload a sitemap.xml file directly to the site's webroot. Note that this will overwrite any other
file that's installed. You will also need to ensure that webroot/sitemap.xml is persisted across deploys so it doesn't remove
your sitemap.xml file after a new deploy.

Installation
--------------

To install:
1. Copy the EvSitemap folder into the 'app/Plugin' directory

2. Add the following code to the 'app/Config/bootstrap.php' plugin load array.

	'EvSitemap' => array(
	    'bootstrap' => true,
	    'routes' => true
	)

3. If you require to overwrite any of the core configuration options add ev_sitemap.php to 'app/Config/Plugin'. The default plugin options can then be copied and updated here.

4. As default, the Sitemap will no be created until you add the behaviour to models you would like to show in the Sitemap

For example

	public $actsAs = array(
		...
		'EvSitemap.Sitemap' => array(
			'changefreq' => 'daily',
			'conditions' => array(),
			'lastmod' => 'modified',
			'loc' => 'buildUrl',
			'primaryKey' => 'id',
			'readPriority' => '0.8'
		)
	);

Add the following line to the robots.txt file, just amending the url to point to the xml version of the sitemap

Sitemap: http://www.domain.co.uk/sitemap.xml

If you have overridden a model you can supply the route info to get nice urls.
For example

    public $actsAs = array(
		...
		'EvSitemap.Sitemap' => array(
			'plugin' => 'ev_shop',
			'controller' => 'ev_shop_products'
		)
	);

Custom URLs
--------------

By default, the plugin will generate URLs for each item based on standard routing. If you need to generate custom URLs, you can create a function in your model for this.

In the Behaviour config you have the line

	'loc' => 'buildUrl'

`buildUrl` in this instance is the name of the function the plugin will call to generate the URL for the item, but you can call this whatever you choose.

If the function doesn't exist in the model, the plugin will ignore this and just generate a standard route.

To use the custom URL functionality, create a function with the same name as defined in the `loc` array key inside the model. This function needs to accept the parameter `Array $item`. `$item` here will be the data from the model in standard form; for example, if the model was called "Job", then $item would look like:

	$item = array(
		'Job' => array(
			'id' => 1,
			'name' => 'Foo',
			is_active => 1
			...
		)
	);

In this function you just generate and return your URL as required (minus the domain), so `/custom-job-route/my-custom-job-name/23` for example.

Full example (assuming our model is called Job):

	public $actsAs = array(
		...
		'EvSitemap.Sitemap' => array(
			'changefreq' => 'daily',
			'conditions' => array(),
			'lastmod' => 'modified',
			'loc' => 'myCustomFunction',
			'primaryKey' => 'id',
			'readPriority' => '0.8'
		)
	);

	public function myCustomFunction($item = array()) {
		$myCustomURL = '/custom-job-route/my-custom-job-name/' . $item['Job']['id'];

		return $myCustomURL;
	}


Caching
=======

The sitemap can be cached using a pre-defined cache configuration by adding the cache configuration's name to the config file. Caching can be set up to last for any duration. Please see [this cake documentation](https://book.cakephp.org/2.0/en/core-libraries/caching.html) for more detail. To clear the cache, visit `/ev_sitemap/sitemaps/refresh` in the browser.

Priority
--------

To set a model's priority individually between records instead of a set number for all entries, replace the `readPriority` value in the config with the name of a field on the model. This field will be used to populate the `<priority>` tag in the xml.

