<?php

/**
 * Utility class that finds and initialises multiple libraries for the EvSitemap plugin.
 */
class SitemapUtil {

	private static $__plugin = 'EvSitemap';

/**
 * Find and initialise a library for the EvSitemap plugin.
 * If an extended version of the library exists then that will be returned.
 *
 * @param string $libName The name of the library.
 * @return Obj.
 */
	public static function init($libName = 'Sitemap') {
		$fullLibName = $libName . 'Lib';

		$libClassName = 'Ext' . $fullLibName;
		App::uses($libClassName, 'Lib/' . self::$__plugin);
		if (class_exists($libClassName)) {
			return new $libClassName();
		}

		// Check for an extended lib first
		$libClassName = self::$__plugin . $fullLibName;
		App::uses($libClassName, 'Lib');
		if (class_exists($libClassName)) {
			return new $libClassName();
		}

		//If an extended version couldn't be found check for a presenter in the plugin
		App::uses($fullLibName, self::$__plugin . '.Lib');
		return new $fullLibName();
	}
}
