<?php
App::uses('EvSitemapAppController', 'EvSitemap.Controller');

App::uses('SitemapUtil', 'EvSitemap.Lib');

class SitemapsController extends EvSitemapAppController {

	public $adminActions = [
		'admin_index'
	];

	protected $_SitemapLib;

/**
 * Constructor.
 *
 * @param CakeRequest $request Request object for this controller. Can be null for testing,
 *  but expect that features that use the request parameters will not work.
 * @param CakeResponse $response Response object for this controller.
 */
	public function __construct($request = null, $response = null) {
		/*
		 * Controller would normally be added from EvCore but as the plugin doesn't require EvCore and for fallback
		 * purposes, add the required helpers and components here.
		 */
		if (!isset($this->components['RequestHandler']) && !in_array('RequestHandler', $this->components)) {
			$this->components[] = 'RequestHandler';
		}

		if (!isset($this->helpers['Html']) && !in_array('Html', $this->helpers)) {
			$this->helpers[] = 'Html';
		}

		if (!isset($this->helpers['Time']) && !in_array('Time', $this->helpers)) {
			$this->helpers[] = 'Time';
		}

		parent::__construct($request, $response);

		$this->_SitemapLib = SitemapUtil::init();
	}

/**
 * Before filter
 *
 * @return void
 */
	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'index'
		));
	}

/**
 * Render the sitemap
 *
 * @return void
 */
	public function index() {
		$listing = array();

		$pageId = Configure::read('EvSitemap.page_id');

		if (! empty($pageId)) {
			$this->loadModel('Page');
			$this->set('data', $this->Page->readForView($pageId));
		}

		$type = $this->request->isXml() ? 'xml' : 'html';
		$listing = $this->_SitemapLib->getListing($type);

		$this->set(compact('listing'));
	}

/**
 * Upload a sitemap to the webroot or other sub folder defined in the config.
 *
 * @return void.
 * @throws NotImplementedException when uploads haven't been enabled in the config.
 */
	public function admin_index() {
		if (empty(Configure::read('EvSitemap.upload.enabled'))) {
			throw new NotImplementedException('You must enable sitemap upload by setting EvSitemap.upload.enabled to true!');
		}

		if (!$this->request->is(['post', 'put'])) {
			return;
		}

		$data = $this->request->data;

		if (empty($data['Sitemaps']['sitemap']['name'])) {
			$this->Flash->fail(
				[
					'title' => 'Upload failed',
					'description' => 'You must upload a file!'
				]
			);

			return;
		}

		if ($data['Sitemaps']['sitemap']['type'] !== 'text/xml') {
			$this->Flash->fail(
				[
					'title' => 'Upload failed',
					'description' => 'Your file must have the .xml extension'
				]
			);

			return;
		}

		$sitemapFilePath = WWW_ROOT;
		if (!empty(Configure::read('EvSitemap.file.path'))) {
			$sitemapFilePath .= Configure::read('EvSitemap.file.path') . DS;
		}

		$sitemapFilePath .= Configure::read('EvSitemap.file.name');

		$uploaded = file_put_contents(
			$sitemapFilePath,
			file_get_contents($data['Sitemaps']['sitemap']['tmp_name'])
		);

		if ($uploaded === false) {
			$this->Flash->fail(
				[
					'title' => 'Upload failed',
					'description' => 'Your file could not be written to the sitemap location',
				]
			);

			return;
		}

		$this->Flash->success(
			[
				'title' => 'Upload Successful',
				'description' => 'Your sitemap has been successfully uploaded'
			]
		);

		return $this->redirect($this->here);
	}

/**
 * Clear the cache and redirect to the sitemap
 *
 * @return void
 */
	public function refresh() {
		$type = $this->request->isXml() ? 'xml' : 'html';
		$this->$_SitemapLib->clearCache($type);

		return $this->redirect(['action' => 'index']);
	}
}
