<?php

App::uses('AppComponent', 'Controller/Component');

class SitemapComponent extends AppComponent {

	public $settings = [];

/**
 * Calls parent. Merges default settings with any settings passed to the controller
 *
 * @param Controller $controller The controller loading this component.
 * @return void.
 * @see Component::initialize()
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);

		$controller->toInject['components'][] = 'EvSitemap.Sitemap';
	}

/**
 * Inject data/content into the admin form.
 *
 * @param array $data  Current request data
 * @param obj   $Model The model currently being modified.
 * @param int   $id    The if of the model record being modified. Null if no id is present.
 * @return void.
 */
	public function injectAdminForm($data, $Model, $id) {
		$existingFields = $this->_controller->viewVars['fields'];

		$fields = array_merge($existingFields, [
			'SitemapConditions.id' => [
				'type' => 'hidden'
			],
			'SitemapConditions.noindex' => [
				'type' => 'boolean',
			],
		]);
		$this->_controller->set(compact('fields'));
	}
}
