<?php

App::uses('AppShell', 'Console/Command');

App::uses('SitemapUtil', 'EvSitemap.Lib');

class SitemapShell extends AppShell {

	protected $_config = [];

	protected $_SitemapLib;

/**
 * @{inheritDoc}
 */
	public function startup() {
		parent::startup();

		$this->_config = Configure::read('EvSitemap');

		$this->_SitemapLib = SitemapUtil::init();
	}

/**
 * Add the available options
 *
 * @return Parser
 */
	public function getOptionParser() {
		$parser = parent::getOptionParser();

		$parser->addSubcommand(
			'generateListings',
			[
				'help' => 'Generate all listing for all sitemaps',
				'parser' => [
					'description' => [
						'This will generate all listing for a sitemap types and include all currently available data. The cache needs to be enabled otherwise this will not have any effect.',
					],
					'options' => [
						'clearCache' => [
							'help' => 'Clear the existing cached sitemap listing.',
							'short' => 'c',
							'boolean' => true,
						],
					],
				],
			]
		);

		$parser->addSubcommand(
			'generateListing',
			[
				'help' => 'Generate a listing for a sitemap',
				'parser' => [
					'description' => [
						'This will generate a listing for one sitemap type and include all currently available data. The cache needs to be enabled otherwise this will not have any effect.',
					],
					'options' => [
						'sitemapType' => [
							'help' => 'The type of sitemap to generate a listing for (html, xml). Default is html.',
							'short' => 't',
						],
						'clearCache' => [
							'help' => 'Clear the existing cached sitemap listing.',
							'short' => 'c',
							'boolean' => true,
						],
					],
				],
			]
		);

		return $parser;
	}

/**
 * Generate listings for every sitemap type.
 *
 * @return void.
 */
	public function generateListings() {
		if (empty($this->_config['cacheName'])) {
			$this->out('The cache is disabled. Without the cache this command has no effect.');
			return;
		}

		$this->_SitemapLib->generateListings($this->param('clearCache'));
	}

/**
 * Generate a listing for a single sitemap type. Default is html.
 *
 * @return void.
 */
	public function generateListing() {
		if (empty($this->_config['cacheName'])) {
			$this->out('The cache is disabled. Without the cache this command has no effect.');
			return;
		}

		$sitemapType = 'html';

		if ($this->param('sitemapType')) {
			$sitemapType = $this->param('sitemapType');
		}

		$this->_SitemapLib->generateListing(
			$sitemapType,
			$this->param('clearCache')
		);
	}
}
