<?php
class AddSitemapConditionsTable extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_sitemap_conditions_table';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = [
		'up' => [
			'create_table' => [
				'ev_sitemap_sitemap_conditions' => [
					'id' => ['type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false, 'key' => 'primary'],
					'model' => ['type' => 'string', 'null' => false, 'default' => null, 'length' => 45, 'collate' => 'utf8_general_ci', 'charset' => 'utf8'],
					'model_id' => ['type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => false],
					'noindex' => ['type' => 'boolean', 'null' => true, 'default' => '0'],
					'created' => ['type' => 'datetime', 'null' => true, 'default' => null],
					'modified' => ['type' => 'datetime', 'null' => true, 'default' => null],
					'indexes' => [
						'PRIMARY' => ['column' => 'id', 'unique' => 1],
					],
					'tableParameters' => ['charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB'],
				],
			],
		],
		'down' => [
			'drop_table' => [
				'ev_sitemap_sitemap_conditions',
			],
		],
	];

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
