# EvSiteSettings

Provides site-wide settings with a CMS inteface.

## Migrations

Extra utils have been added to ease creating site setting migrations.

### Site Settings

`createOnceWithCategory($slug, $categorySlug, $type, $options = []);`

Options are:

- 'name' - The setting name. If not specified a humanized version of the slug is used.
- 'valueOptions' - The options to use if the type is 'select'. Use the format 'optionValue:optionName,...'
- 'value' - The initial value of the setting
- 'sequence' - The setting's sequence value. Defaults to 0.
- 'preventEdit' - If the setting should be protected. This will also apply to the category if the category is created.

The following settings only apply if the category is created in this call:

- 'categoryName' - The category name. The category slug will be humanized if this is not set.
- 'categorySequence' - Defaults to 0

To delete use:

`deleteWithSlug($slug, $categorySlug)`

### Site Setting Categories

To create:

`createCategoryOnce($slug, $name = null, $sequence = 0, $preventEdit = false);`

To delete (including site settings in this category):

`deleteWithSlug($slug)`

### Exporting Site Settings

Using the `EvMigrationUtil` library, site settings can be exported as a migration. The category will be created as part of the migration if it doesn't already exist. To export to a migration use:

	app/Console/cake EvMigrationUtil.Migration export EvSiteSettings.SiteSetting category_slug.setting_slug

Replace `category_slug.setting_slug` with the part normally added to `Configure::read(SiteSetting.category_slug.setting_slug)`.






