<?php
App::uses('EvSiteSettingsAppModel', 'EvSiteSettings.Model');

class SiteSettingCategory extends EvSiteSettingsAppModel {

	/**
	 * Display field
	 *
	 * @var string
	 */
	public $displayField = 'name';

	/**
	 * Validation rules
	 *
	 * @var array
	 */
	public $validate = array(
		'name' => array(
			'notEmpty' => array(
				'rule' => array('notBlank'),
				'message' => 'A category name is required.',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'array_slug' => array(
			'notEmpty' => array(
				'rule' => array('notBlank'),
				'message' => 'A slug for the settings array is requird.',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		)
	);

	public $hasMany = array(
		'SiteSetting' => array(
			'className' => 'EvSiteSettings.SiteSetting',
			'cascade' => true,
			'dependent' => true
		)
	);
}
