<?php
App::uses('EvSiteSettingsAppModel', 'EvSiteSettings.Model');

class SiteSetting extends EvSiteSettingsAppModel {

	/**
	 * Display field
	 *
	 * @var string
	 */
	public $displayField = 'name';

	public $order = array('SiteSetting.array_slug' => 'ASC');

	public $belongsTo = array(
		'SiteSettingCategory' => array(
			'className' => 'EvSiteSettings.SiteSettingCategory'
		)
	);

	/**
	 * Validation rules
	 *
	 * @var array
	 */
	public $validate = array(
		'name' => array(
			'notEmpty' => array(
				'rule' => array('notBlank'),
				'message' => 'A Setting name is required.',
			),
		),
		'array_slug' => array(
			'notEmpty' => array(
				'rule' => array('notBlank'),
				'message' => 'A slug for the settings array is required.',
			),
			'unique' => array(
				'rule' => 'isUnique',
				'message' => 'Slugs must be unique',
			),
		),
		'type' => array(
			'notEmpty' => array(
				'rule' => array('notBlank'),
				'message' => 'You must select a type.',
			),
		),
		'site_setting_category_id' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				'message' => 'You must select a category.',
			)
		)
	);

	public $findMethods = array('grouped' => true);

	protected function _findGrouped($state, $query, $results = array()) {
		if ($state == 'before') {
			$query['contain'][] = 'SiteSettingCategory';

			return $query;
		} else {

			$data = array();

			foreach ($results as $result) {
				$data[$result['SiteSettingCategory']['name']][] = $result;
			}

			$results = $data;
		}

		return $results;
	}

	/**
	 * beforeSave, prefill sequence if none entered
	 *
	 * Called before each save operation, after validation. Return a non-true result
	 * to halt the save.
	 *
	 * @param array $options Options passed from Model::save().
	 * @return bool True if the operation should continue, false if it should abort
	 * @link http://book.cakephp.org/2.0/en/models/callback-methods.html#beforesave
	 * @see Model::save()
	 */
	public function beforeSave($options = array()) {
		$return = parent::beforeSave($options);

		if (empty($this->data['SiteSetting']['sequence'])) {
			$this->data['SiteSetting']['sequence'] = 0;
		}
		return $return;
	}
}
