<?php

App::uses('BaseMigrationModelUtil', 'EvMigrationUtil.Lib');

class SiteSettingCategoryMigrationModelUtil extends BaseMigrationModelUtil {

/**
 * Builds a site setting category
 *
 * @param string $slug The site setting category slug
 * @param string $name The tab name
 * @param int $sequence The sequence for the tab
 * @param bool $preventEdit Prevents it being edited in the CMS
 * @return int|bool The Id on success or false on fail
 */
	public function createCategoryOnce($slug, $name = null, $sequence = 0, $preventEdit = false) {
		return $this->createOnce([
			$this->Model->alias . '.array_slug' => $slug,
		], [
			'name' => empty($name) ? InflectorExt::humanize($slug) : $name,
			'array_slug' => $slug,
			'sequence' => $sequence,
			'prevent_edit' => !empty($preventEdit)
		]);
	}

/**
 * Deletes based on a slug. Also deletes orphaned site settings.
 *
 * @param string $slug The setting slug
 * @return void
 */
	public function deleteWithSlug($slug) {
		$categoryId = $this->Model->field('id', ['array_slug' => $slug]);
		$this->Model->SiteSetting->deleteAll([
			$this->Model->SiteSetting->alias . '.site_setting_category_id' => $categoryId
		]);
		$this->Model->delete($categoryId);
	}

}
