<?php

App::uses('EvSiteSettingsAppController', 'EvSiteSettings.Controller');

class SiteSettingCategoriesController extends EvSiteSettingsAppController {

	protected function _adminFilterFields() {
		return array();
	}

	/**
	 * show the array slug on the index page
	 */
	protected function _adminIndexColumnsWhitelist() {
		$modelAlias = $this->{$this->modelClass}->alias;

		$fields = parent::_adminIndexColumnsWhitelist();

		$fields[] = $modelAlias . '.array_slug';

		return $fields;
	}

	public function beforeFilter() {
		parent::beforeFilter();

		if (! $this->Permissions->hasSuperAdminPermission($this->Auth->user())) {
			$this->Session->setFlash(
				'You don\'t have permission to view that page',
				'flash_fail'
			);
			$this->redirect('/');
		}
	}
}
