<?php

App::uses('AppComponent', 'Controller/Component');

/**
 * Site Setting component
 *
 * Doesn't do much appart load any site settings from the SiteSetting table
 * and makes them available to Configure::read('SiteSetting.foo')
 *
 * @package CoreCMS/SiteSetting
 */
class SiteSettingsComponent extends AppComponent {

	/**
	 * create config entries for each site setting
	 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);

		$this->_controller->loadModel('EvSiteSettings.SiteSetting');

		$settings = $this->_controller->SiteSetting->find(
			'all',
			array('contain' => 'SiteSettingCategory')
		);

		foreach ($settings as $setting) {
			Configure::write('SiteSetting.' . $setting['SiteSettingCategory']['array_slug'] . '.' . $setting['SiteSetting']['array_slug'], $setting['SiteSetting']['value']);
		}
	}
}