<?php
App::uses('PluginInstallShell', 'shells');
App::uses('MigrationUtil', 'EvMigrationUtil.Lib');

class EvSiteSettingsInstallShell extends PluginInstallShell {

	public $uses = [
		'EvSiteSettings.SiteSetting',
		'EvSiteSettings.SiteSettingCategory',
	];

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run() {
		parent::run();

		$SiteSettingCategory = MigrationUtil::init('EvSiteSettings.SiteSettingCategory');

		$siteSettingCategories = $SiteSettingCategory->createAllOnce(['name', 'array_slug', 'sequence'], [
			'general' => [
				'name' => 'General',
				'array_slug' => 'general',
				'sequence' => 10,
			],
			'users' => [
				'name' => 'Users',
				'array_slug' => 'users',
				'sequence' => 20,
			],
			'seo' => [
				'name' => 'SEO',
				'array_slug' => 'seo',
				'sequence' => 30,
			],
			'tracking' => [
				'name' => 'Tracking',
				'array_slug' => 'tracking',
				'sequence' => 30,
			],
		]);

		$this->SiteSetting->saveMany(
			[
				[
					'name' => 'Administrator Email',
					'array_slug' => 'admin_email',
					'type' => 'email',
					'options' => null,
					'value' => 'admin@evoluted.net',
					'site_setting_category_id' => $siteSettingCategories['general'],
					'sequence' => 10,
				],
				[
					'name' => 'Site Title',
					'array_slug' => 'site_title',
					'type' => 'string',
					'options' => null,
					'value' => 'Evoluted CMS',
					'site_setting_category_id' => $siteSettingCategories['general'],
					'sequence' => 20,
				],
				[
					'name' => 'Enable User Registration',
					'array_slug' => 'enable_registration',
					'type' => 'boolean',
					'options' => null,
					'value' => 0,
					'site_setting_category_id' => $siteSettingCategories['users'],
					'sequence' => 10,
				],
				[
					'name' => 'User Activation',
					'array_slug' => 'activation',
					'type' => 'select',
					'options' => 'auto:Automatic Activation,email:Email Verification,manual:Manual Activation',
					'value' => 'email',
					'site_setting_category_id' => $siteSettingCategories['users'],
					'sequence' => 20,
				],
				[
					'name' => 'Password Rules',
					'array_slug' => 'password_rules',
					'type' => 'html_lite',
					'options' => null,
					'value' => '<p><strong>Your Password must:</strong></p><ul><li>Be a least 15 characters long</li><li>Include a mix of alphabetic and numeric characters</li><li>Include a mix of uppercase and lowercase characters</li><li>Include at least one special character (!@#$&amp;*)</li><li>The new password cannot match the one previously used</li></ul>',
					'site_setting_category_id' => $siteSettingCategories['users'],
					'sequence' => 30,
				],
				[
					'name' => 'Google Analytics Tracking Code',
					'array_slug' => 'google_analytics',
					'type' => 'string',
					'options' => null,
					'value' => null,
					'site_setting_category_id' => $siteSettingCategories['general'],
					'sequence' => 30,
				],
				// Add a plain text field for entering raw JSON for the organization schema
				// http://schema.org/Organization
				[
					'name' => 'Organization Schema Data (JSON)',
					'array_slug' => 'organization_schema',
					'type' => 'text_plain',
					'options' => null,
					'value' => null,
					'site_setting_category_id' => $siteSettingCategories['seo'],
					'sequence' => 10,
				],
				[
					'name' => 'Call Tracking',
					'array_slug' => 'call_tracking',
					'type' => 'text_plain',
					'options' => null,
					'value' => null,
					'site_setting_category_id' => $siteSettingCategories['tracking'],
					'sequence' => 30,
				],
				[
					'name' => 'Conversion Success Code',
					'array_slug' => 'conversion_success_code',
					'type' => 'text_plain',
					'options' => null,
					'value' => null,
					'site_setting_category_id' => $siteSettingCategories['tracking'],
					'sequence' => 30,
				],
			]
		);
	}
}
