<?php
class AddGtmToAllEnvironmentsFlag extends CakeMigration {

    /**
     * Migration description
     *
     * @var string
     */
    public $description = 'add_gtm_to_all_environments_flag';

    /**
     * Actions to be performed
     *
     * @var array $migration
     */
    public $migration = array(
        'up' => array(
        ),
        'down' => array(
        ),
    );

    /**
     * Before migration callback
     *
     * @param string $direction Direction of migration process (up or down)
     * @return bool Should process continue
     */
    public function before($direction) {
        return true;
    }

    /**
     * After migration callback
     *
     * @param string $direction Direction of migration process (up or down)
     * @return bool Should process continue
     */
    public function after($direction) {
        if ($direction == 'up') {
            $this->SiteSettingCategory = EvClassRegistry::init('EvSiteSettings.SiteSettingCategory');
            $this->SiteSetting = EvClassRegistry::init('EvSiteSettings.SiteSetting');

            $gtmCodeCategory = $this->SiteSettingCategory->findByArraySlug('gtm_code');

            return (bool) $this->SiteSetting->save(
				array(
					'name' => 'Allow GTM Code in all environments',
					'array_slug' => 'gtm_code_all_environments',
					'type' => 'boolean',
					'options' => null,
					'value' => '0',
					'site_setting_category_id' => $gtmCodeCategory['SiteSettingCategory']['id'],
					'sequence' => 3
				)
            );
        }

        return true;
    }
}
