<?php
class AddGtmCodes extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_gtm_codes';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction == 'up') {
			$this->SiteSettingCategory = EvClassRegistry::init('EvSiteSettings.SiteSettingCategory');
			$this->SiteSetting = EvClassRegistry::init('EvSiteSettings.SiteSetting');

			$gtmCodeCategory = $this->SiteSettingCategory->save(
				array(
					'name' => 'Google Tag Manager',
					'array_slug' => 'gtm_code',
					'sequence' => 40
				)
			);

			$this->SiteSetting->saveMany(
				array(
					array(
						'name' => 'GTM Code - head',
						'array_slug' => 'gtm_code_head',
						'type' => 'text_plain',
						'options' => null,
						'value' => '',
						'site_setting_category_id' => $gtmCodeCategory['SiteSettingCategory']['id'],
						'sequence' => 1
					),
					array(
						'name' => 'GTM Code - body',
						'array_slug' => 'gtm_code_body',
						'type' => 'text_plain',
						'options' => null,
						'value' => '',
						'site_setting_category_id' => $gtmCodeCategory['SiteSettingCategory']['id'],
						'sequence' => 2
					)
				)
			);
		}

		return true;
	}
}
