$(document).ready(function(){
	$(document).on('click', '.add-new-variantImage', function(e){
		e.preventDefault();
		var $wrapper = $(this).parent().find('.file-wrapper');
		addNewVariantImageSlot($wrapper);
	});

	$(document).on('change', '.input-radio-image-restriction', function(e){
		e.preventDefault();
		if ($(this).val() > 0) {
			$(this).closest('fieldset').siblings('.preview__variant-image-options').show();
		} else {
			$(this).closest('fieldset').siblings('.preview__variant-image-options').hide();
		}
	});

	//Hide or show options depending on saved restriction
	$('.input-radio-image-restriction:checked').each(function(radioButton){
		if ($(this).val() > 0) {
			$(this).closest('fieldset').siblings('.preview__variant-image-options').show();
		} else {
			$(this).closest('fieldset').siblings('.preview__variant-image-options').hide();
		}
	});

});

/**
 * Adds a new image slot checking first to see if we have any available ones left.
 */
function addNewVariantImageSlot($wrapper) {

	//If we have run out of available image slots then we can't add another
	if(!checkVariantImageLimit($wrapper, 'variantImage')) {
		return false;
	}

	model = $wrapper.data('model');
	type = $wrapper.data('type');
	fields = $wrapper.data('fields');

	row_key = $wrapper.find('.file--image').length;

	url = "/ajax/variantImages/add/" + model + "/" + row_key + "/" + type;

	url += $wrapper.data('prefix') ? '/' + $wrapper.data('prefix') : '/false';
	url += $wrapper.data('plugin') ? '/' + $wrapper.data('plugin') : '/false';
	url += $wrapper.data('fields') ? '/' + $wrapper.data('fields') : '/false';

	$.ajax({
		url: url,
		context: this,
		success: function(data) {

			data = jQuery.parseJSON(data);

			if (data.status == 'success') {
				console.log(data);

				$wrapper.append(data.content);

				//TODO: Change to use the chooseFileButton Method
				var _this = $wrapper.find('.file--image').last().find('input[type="file"]');
				console.log(_this);

				var previewTools = _this.parents('.input.preview__tools__input');

				previewTools.addClass('choose-file');

				if (previewTools.length) {
					previewTools.find('label').text('Upload Image');
				}
			}

		}
	});

	return false;

}

/**
 * Checks whether there is any more document/image slots available and if not
 * hides the 'add' buttons.
 *
 * @param {jQuery element} $wrapper we are able to have multiple image/file
 *                       		  sections so we need to define which one we
 *                       		  are currently in.
 * @param {string}         file     'document'/'image'
 * @param {boolean}        initial
 *
 */
function checkVariantImageLimit($wrapper, file, initial) {

	if (typeof file == 'undefined') {
		file = 'document';
	}

	if (typeof initial == 'undefined') {
		initial = false;
	}

	if ($wrapper.data(file + 'slots')) {
		//We are on the wrapper div so lets go
		fileSlots = $wrapper.data(file + 'slots');
	} else {
		//Look for wrapper div
		fileSlots = $wrapper.parents('.file-wrapper').data(file + 'slots');
	}

	row_key = $wrapper.find('.file--' + file).length;


	// Check how many slots we are using already and whether there is a limit
	// If unset or set to -1 assume unlimited
	if (typeof fileSlots != 'undefined' && fileSlots != -1) {

		if (fileSlots <= row_key) {

			// Adding another file would take us over the limit so just return false
			$wrapper.parent().find('.add-new-' + file).hide(); // If not already hidden hide.
			return false;

		} else if (fileSlots-1 == row_key && !initial) {

			// We now have our maximum number of slots so hide the add button
			// but carry on and add extra slots
			$wrapper.parent().find('.add-new-' + file).hide();
			return true;

		} else if(fileSlots > row_key) {
			$wrapper.parent().find('.add-new-' + file).show();
			return true;

		}
	}
	return true;
}
