$(document).ready(function() {

	$('.cloneable').cloneable({
		pre_add_item_callback: function(item) {
			item.find('.help-block').remove();

			return item;
		},
		delete_item_callback: function(item) {
			var fieldId = item.find('.field-id').val();

			if (parseInt(fieldId) > 0) {
				var toDelete = item.parents('.cloneable').find('.to-delete');
				toDelete.val(toDelete.val() + fieldId + ',');
			}
		}
	});

	// trigger the sorting for the custom fields
    $('.sortable').sortable({
        items: '> .clone-row',
        stop: function(event, ui) {
            updateSortOrder();
        }
    });

    $('.sortable').parents('form').on('submit', function() {
        updateSortOrder();
    });

    //Reorder Option - up
    $('.s.s--up').click(function(e) {
    	e.preventDefault();

    	reorderOption($(this), true);
    });

    //Reorder Option - down
    $('.s.s--down').click(function(e) {
    	e.preventDefault();

    	reorderOption($(this), false);
    });
});

function reorderOption(reorderButton, moveUp) {
	var currentOptionRow = reorderButton.closest('.clone-row');
	var currentSequence = currentOptionRow.find('input.sequence-input').val();

	if (moveUp) {
		var maximumValue = currentSequence;
		var minimumValue = 0;
	} else {
		var maximumValue = $('.clone-row').length - 1;
		var minimumValue = currentSequence;
	}

	if (maximumValue > minimumValue) {
		if (moveUp) {
			var switchOptionRow = currentOptionRow.prev();
		} else {
			var switchOptionRow = currentOptionRow.next();
		}
		var switchSequence = switchOptionRow.find('input.sequence-input').val();

		//Update option sequence values
		currentOptionRow.find('input.sequence-input').val(switchSequence);
		switchOptionRow.find('input.sequence-input').val(currentSequence);

		if (moveUp) {
			switchOptionRow.insertAfter(currentOptionRow);
		} else {
			currentOptionRow.insertAfter(switchOptionRow);
		}
	}
}
