// The chain of options that have been selected in order of selection.
// This helps decide which options should take priority when limiting selections.
//var optionSelections = [];

// The available paths
var availablePaths = [];

/**
 * Initialises the shop options code with default options and paths
 *
 * Options are:
 *   availablePaths: An array that can be walked from the first to last choice to decide available options. You can build this using the ProductsHelper->getAvailableOptionPaths
 */

function initShopOptions( initOptions ) {
	availablePaths = initOptions.availablePaths;
}

/**
 * Returns current info about the user's selection. Until they have chosen all options this will not be a variant but can give useful information like minimum price.
 * Check for a variant_id property in the return object to determine if we have found a single matching variant.
 */
function getCurrentVariantInfo( getOptionValueCallback )
{
	var optionSelections = _getCurrentSelectionOrder();
	var currentLevel = availablePaths;

	for ( var i = 0; i < optionSelections.length; i++ ) {
		var optionGroupId = optionSelections[i];
		var optionId = getOptionValueCallback(optionGroupId);

		if (currentLevel['options'][optionGroupId] == undefined) {
			return currentLevel;
		}

		if (currentLevel['options'][optionGroupId][optionId] == undefined) {
			return currentLevel;
		}

		currentLevel = currentLevel['options'][ optionGroupId ][ optionId ];
	}
	return currentLevel;
}

/**
 * Stores the current order of selection in an input to preserve the value on navigating back
 */

function _getCurrentSelectionOrder() {
	var optionSelections = document.getElementById('productOptionsSelected').value;
	if (optionSelections != "") {
		optionSelections = optionSelections.split(',');
	} else {
		optionSelections = [];
	}
	return optionSelections;
}

function _saveCurrentSelectionOrder( selections ) {
	document.getElementById('productOptionsSelected').value = selections.join(',');
}

/**
 * Call when an option is changed
 * The callback system means that custom input types can be used.
 *
 * changedValue - The new value of the option. This is ignored if -1 is passed for the type.
 * changedType - The type of option that has just changed (i.e. option group id.) Pass -1 to just refresh the available options.
 * getOptionValueCallback - a function that returns the current value of a given option type. Use format function(optionType):value
 * setOptionsCallback - the function to call when setting the availablility for all options of one type. Use format function(optionType,options). Options will be passed as an array with values as the key.
 */

function onShopOptionChanged( changedValue, changedType, getOptionValueCallback, setOptionsCallback ) {

	optionSelections = _getCurrentSelectionOrder();

	// If -1 is passed as the type this is just an update, not a new selection
	if ( changedType >= 0 ) {
		if ( optionSelections.indexOf(changedType.toString()) === -1 ) {
			// If not already in the chain add it in
			optionSelections.push(changedType.toString());
		} else if ( changedValue == 0 ) {
			// If in the chain but reset, remove it from the chain
			optionSelections.splice( optionSelections.indexOf( changedType.toString() ), 1 );
		}
	}

	var currentLevel = availablePaths['options'];

	if ( optionSelections.length > 0 ) {
		for( var i = 0; i < optionSelections.length; i++ ) {

			var optionType = optionSelections[i];
			var currentValue = getOptionValueCallback(optionType);

			// The first option to be chosen should be allowed to be changed at any time and
			// adjust the other options to match
			if ( i == 0 ) {
				setOptionsCallback( optionType, availablePaths['options'][optionType] );
			}

			if ( currentValue == 0 ) {
				// This option has been deselected by the filter - remove it from the chain
				optionSelections.splice( i, 1 );
				i--;
				continue;
			}

			// If it can't find it it breaks the rest of the script
			if (typeof currentLevel[optionType][currentValue] === 'undefined') {
				continue;
			}

			for( var nextOptionType in currentLevel[optionType][currentValue]['options'] ) {
				// Set the options available based on the current path
				setOptionsCallback( nextOptionType, currentLevel[optionType][currentValue]['options'][nextOptionType] );
			}

			currentLevel = currentLevel[optionType][currentValue]['options'];

		}
	} else {
		// Reset the values in all select boxes to be able to select anything
		for( optionType in availablePaths['options'] ) {
			//resetAllCallback( availablePaths['options'] );
			setOptionsCallback( optionType, availablePaths['options'][optionType] );
		}
	}

	_saveCurrentSelectionOrder( optionSelections );

}
