# EvShop

## Installation

Run `composer require evoluted/shop`

Simply add EvShop to the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvShop`.

The installer will automatically setup the database tables, add all the needed menu links to the admin, create the templates needed to display the pages and finally create the pages needed for the brands / category / products listing screens and automatically create and save the `ev_shop` config.

## How it works

### Shop Core

The bulk of the shop is handled via the brands, categories and products components which are used to retrieve the paginated listing of each section. The standard shop format is setup within the bundled controllers but using these components will allow you to add listings to other sections of a site.

All pages also run using the template system, basic templates for all of these are bundled with the plugin that should show all the available variables. If for some reason a template doesn't exist the shop will fallback and use a more basic "fallback template" also bundled with the plugin.

### Product Attributes

If enabled in the config, attributes are properties of a product that can be used for filtering. Attributes do not affect variants or pricing and can only have one value per attribute group per product. Individual product attributes can be hidden from filters by unticking the `show_in_filters` option in the attribute admin. Attribute filters will only show if they have more than one available option for selection.

### Brands Hierarchy

A hierarchy has been added to brands in the form of a `parent_id` field to allow for brands to be grouped together. I.e. We have the ability to have the parent brand of "Nike" and now group children of "Nike" such as "Nike Presto", "Nike Air Max" etc. This functionality allows for deeper filtering of products - the front end filtering functionality should be added to suit each case and doesn't working out of the box.

#### Sub Brands

By default, products that belong to sub-brands will **not** be fetched out when filtering by a parent-brand. However, this can be enabled by setting `showSubBrandProducts` to true in the config.

### Option Groups / Options

Option groups and options work on a global basis in that they are added separately from products. Products then simply retrieve the full list of options ready for the user to select. Simply means that alot of work can be cut down for a user as they won't have to manually enter options for every product.

Options are also not directly tied to a product, options only ever get tagged to a variant so we can keep a check of which options make up each variant.

#### Managing option selections in the shop

When using variants, some combinations of options may result in an option that is out of stock or generally not available. Other combinations might result in a variant that is a different price. To manage what options should be available after others have been selected, an options selection tree can be built using the `ProductsHelper::getAvailableOptionPaths($data)` function. This builds an array that maps every possible selection in every possible order. It will also provide intermediate values if a full selection has not been made (e.g. size has been chosen but not colour.) The `$data` parameter is a `Product` array with the following contains:

```
'contains' => [
	'Variant' => [
		'Option',
		'VariantPricing'
	]
]
```

The array will be in the following format:
```
[
	These root values can be used when the page is first loaded without any selections made.
	'minPrice' => [
		This is the price of the lowest priced variant available from the current selection. It will always have a lowest_price which will either be the sale_price or the price if the former has not been set. The sale_price field will not be set if the variant does not have a sale price.
		'rrp' => 10,
		'price' => 8,
		'sale_price' => 5,
		'lowest_price' => 5
	],
	'minPriceFormatted' => This will always be the lowest_price from minPrice above e.g. "£5.00",
	'minPriceWasFormatted` => This will be either rrp or the regular price if the variant has a sale price e.g. "£8.00",
	'availability' => Either 'good', 'some_low', 'low' or 'none',
	'options' => [
		Option group Id => [
			Option Id => [
				This will either be a recursion of the array above with aggregated values and further options or it will be a variant in the following format:
				'variant_id' => The variant ID that matches all of the selected options,
				'price' => Same as minPrice above but for this specific variant,
				'wasPriceFormatted' => Save as minWasPriceFormatted above but specific to this variant,
				'nowPriceFormatted' => Save as minPriceFormatted above but specific to this variant,
				'availability' => Either 'good', 'low', 'delayed' or 'none'
			]
		]
	]
]
```

This can be used in PHP but is more useful when passed to JS. The `ProductsHelper::initOptionsPaths($data)` will create a JS array from the same `Product` array and include some base JS code to get you started with enabling controls to respond to the users selections. To use this code, set up your form with your options and in a `change` listener on the form elements, call this function:

```
onShopOptionChanged( changedValue, changedType, getOptionValueCallback, setOptionsCallback )
```

The parameters are:
* **changedValue**: The new id of the option in an option group. (This is ignored if -1 is passed for the type)
* **changedType**: The option group id of the changed option or -1 to act as a refresh without making any selections.
* **getOptionValueCallback**: This is a callback function with the signature `function(optionType):optionValue` that will return the current selected option id when passed an option group id.
* **setOptionsCallback**: A callback function with signature `function(optionType,options):void` where optionType is the option group id and options is an object with properties for each available option id. Use this to determine which options should be available with `options.hasOwnProperty(optionId)`. This can also be used to check availability as the intermediate value or variant level on the tree will be the options property's value accessible using `options[optionId]`.

You can also use the `getCurrentVariantInfo( getOptionValueCallback )` function to get the current position on the options tree. This will be either an intermediate level with aggregated values or a specific variant. To detect the difference check for the presence of a `variant_id` property on the returned object.

#### Option Group Field Types

From version 2.8.5.0 EvShop supports custom field types for each Option Group. This lets you define a list of field elements and names in your EvShop config (see the included config file for an example), which are then selectable via the OptionGroup add/edit form in the admin area.

You can then make use of the new `showOptionField()` method in the Product Helper to display your fields, using the form field elements to handle the display.

A good example of when you would use this would be if you needed to allow people to pick the colour of a product, and instead of showing a standard select list, wanted to show each colour as a box you click.

##### How to use

Using the above colour picker example, you would first update your product template to return all the available options for the product, and store them into a variable:

	$options = $this->Products->getAllAvailableOptions($data);

Next as a very basic example we'll loop through these and spit out all our option fields:

	foreach ($options as $id => $option):
		echo $this->Products->showOptionField($id, $option);
	endforeach;

You will be presented with all your fields (only if you have given each of them a field type).

Next you need to update your EvShop config to include the `optionGroupFieldTypes` array. An example of this can be found in the config file included in EvShop.

##### Creating field types

To create a new field type, first create a new element in `View/Plugins/EvShop/Elements/OptionGroupFields` called something like `colorpicker.ctp`

Inside this file you'll be writing the html to handle the display of the field type. So for a colour picker this might be a label followed by a radio element.

The variables you have available to you are:

* **field** - contains the original option array, exactly as you'd normally use it if you were outputting the option fields manually in your template.
* **fieldName** - the dot notation field name (e.g Product.OptionGroup.1)
* **attrs** - Optional overridden attributes from showOptionField being used in your template
* **labelAttrs** - Optional overridden label attributes from showOptionField being used in your template
* **fieldOptions** - This is the simplified options array from inside your field array. This contains a simple value => name list, commonly needed for radios and checkboxes.


### Variants

To help keep the code simple, variants are always used regardless of whether any options are ticked for the product or whether they are disabled or not.

Doing this allows us to keep the plugin simple, it means that each product will always have a least 1 variant.

If it's from a product that was tagged to options, these options will then also be tagged to the variant so that we may identify which options each variant is made up of.

#### Bulk Variant Price Updater
From version 2.2.2.0 the plugin now has a bulk update tool to allow staff to update a number of variant's pricing at once. This is quite simply just a glorified javascript file that pulls data from data attributes and then updates records based on what options were selected.

This tool only shows if the showVariants config variable is set to true, as it's not got any purpose on single-variant sites.

In addition if the 'autoManageCurrencies' config option is set to true, it'll only show pricing for the default currency as other currencies will be automatically updated by the currency plugin upon saving.

To use version 2.2.2.0 of the shop you need to be using an up to date copy of core-cms that contains the bootstrap bridge.

#### Per-Variant Images

In some situations it may be desireable to have different images display depending on the options/variant the customer has selected. This functionality exists and is enabled by default with the config var `hasVariantImagery`, however, extra setup is needed to enable tagging of images within the administration area. Puckstop is the original site that implemented this and as such uses this feature quite heavily.

You will need to extend `Model/Product.php` and create a new Image Slot _variable_ - this is not an addition to the existing `$imageSlots` variable but a new variable which must be called `$variantImageSlots`. Once this is done, create your slot within this as normal, including things like alt fields, how many images to allow etc. One thing to note though is that the slot cannot be called `main`. This is due to how the VariantImages system builds the image slot name for the Images table conflicting with how the images system strips the name "Main" from any image slots.

Once this is all set up, upload your images to the new tab which will appear on the Product Editor - the ability to tag these images will show _after_ they have been saved. After this you should have the option to leave the image as a "generic" image, or restrict it to a variant. This will add in extra fields for each OptionGroup from which you can select as many or as few options as you like.

On the front-end, the images will be contained inside the `data` array as normal. In addition to the image, they will have an extra array called `VariantImageOption`. This allows you to match these images with the option IDs from your option/variant selection on the product detail page. However there are functions in the `ProductsHelper` which are set up to fetch images based on certain conditions:

* `getListingImage` - Simply gets the listing image for an item with no restrictions
* `getRestrictedImagesForVariant` - Returns an array of all images relevant to the selected Variant
* `getMostRelevantImageForVariant` - Returns the first image for a variant it can find, preferring Restricted images if available
* `getRestrictedVariantImages` - Extracts restricted images from a Variant Images array
* `getGenericVariantImages` - Extracts _un_restricted images from a Variant Images array

### Variant Rebuilding

The system attempts to be clever with when it rebuilds the variants as in doing so, **it may cause you to lose SKU / Pricing data**. To help minimise the risk of losing data the system tries to detect when an option from an option group has been added or removed before rebuilding.

e.g. If we previously had selected Colour group options of Red and Blue and Size group options of Regular and Large we would have 4 variants created

* Red Regular
* Red Large
* Blue Regular
* Blue Large

Upon selecting another colour, we simply need to create another 2 variants linking the new colour to each size so the existing variants are left as they are.

Whereas adding 2 options of Wood and Metal from the Type option group would require the rebuilding of all the current options as there is no longer `Red Regular` as we have now `Red Regular Wood` and `Red Regular Metal`.

Similarly, if the two Type options were removed, we would have to rebuild all variants again as `Red Regular Wood` and `Red Regular Metal` would no longer be options.

### Trade Pricing
EvShop supports custom trade pricing, however this will not be displayed as default.

Firstly there is a site setting (SiteSetting.ev_shop.enable_trade_pricing) to globally enable/disable the trade account support in EvShop. This needs to be enabled.

To display trade pricing to your customers instead of the list pricing, a temporary session called 'EvShop.isTrade' should be set with a value of true.

This will then be used to return trade prices instead of the standard (or sale) price.

This would then basically be used on a per-site basis. For example you might just have an is_trade flag on a customer record. Then you extend your existing login functionality to set that session if they are logged in and have the is_trade flag.

This could have been done as a hard-coded check in EvShop but keeping it as a session seems like a better option as it's then not tied to a field on a specific table, and can be used on the fly.

Tax will still be applied to trade prices as standard, however this can be disabled using a site setting called 'SiteSetting.ev_shop.disable_tax_on_trade_pricing

### Managing Product Options

A `manageOptions` flag can be toggled from the plugin config file to determine whether admin users can manage more than the `name` field on a per product option basis. Toggling the `manageOptions` option to `true` inserts a link underneath each product option on the "Options" tab, found on the "Option" admin edit form template. Enabling the functionality will allow admin users to update the `data` field and also upload a single image to the product option.

### Brands Hierarchy

A hierarchy has been added to brands in the form of a `parent_id` field to allow for brands to be grouped together. I.e. We have the ability to have the parent brand of "Nike" and now group children of "Nike" such as "Nike Presto", "Nike Air Max" etc. This functionality allows for deeper filtering of products - the front end filtering functionality should be added to suit each case and doesn't working out of the box.

### Category Overrides

When using filters on a category page, it may be desirable to override the content in a category to better reflect the chosen options a user has made in the filters to improve SEO or provide a more custom user experience. This can be accomplished with category overrides. A setting in the config, `useCategoryOverrides`, enables/disables this functionality. When enabled an evoluted user may create an override by going to the categories in the CMS; in the toolbar there will be a link to the category overrides.

To create an override, a category must be selected. Content will not be replaced unless it is set. To apply an override to a set of filters, a brand or a set of options must be selected. If neither a brand or a set of options then the override will not be used. When a user selects the exact combination of brand/options then the override content will replace the data in the category that was selected.

#### Extracting Filters

As EvShop does not contain any standard functionality to create/populate filters some setup will need to be performed before the override will work. The following steps need to be taken:

- Extend the `CategoryOverridesComponent`.
- Extend the `_getFilterBrand()` and `_getFilterOptions()` methods inside the component.
- Extract the brand id and options ids from your project's filters.
- Return the brand id as an integer and the options as a list of integer ids.

An example of the `_getFilterBrand()` method being extended to return the brand id from a filter.

```
<?php

App::uses('CategoryOverridesComponent', 'EvShop.Controller/Component');

class EvShopCategoryOverridesComponent extends CategoryOverridesComponent {

/**
 * Get the id of the brand from the filter. Overrides can only be associated with a single brand so if multiple brands
 * have been selected in the filter then an override can't be applied.
 *
 * @return int The id of the brand to override by.
 */
	protected function _getFilterBrand() {
		$brand = parent::_getFilterOptions();

		if (empty($this->_controller->request->params['named'])) {
			return $brand;
		}

		$filter = $this->_controller->organiseParams(
			$this->_controller->request->params['named']
		);

		if (empty($filter['Brands']) || count($filter['Brands']) > 1) {
			return $brand;
		}

		if (empty($this->_controller->Brand)) {
			$this->_controller->loadModel('EvShop.Brand');
		}

		return $this->_controller->Brand->field(
			'id',
			[
				$this->_controller->Brand->alias . '.name' => array_shift($filter['Brands'])
			]
		);
	}
}
```

## Setup

Setup is relatively simple for a standard E-Commerce setup. As default, Variants and brands are active and all that will need setting overriding in the config are the ID numbers for the brand, category, product listing pages. This is so on the main landing page for each of those section SEO meta data can be applied. This should however be handled by the installer as mentioned above.

## Extending / Using

### Default Setup

As default, the shop plugin will automatically build up a breadcrumb trail and assign to the templates. Assuming `EvTax` is retrieved from composer, each product and variant will have Tax set up for usage, as well as each variant having an inventory row created within EvInventory (again if included via composer).

For full documentation on extending controllers, see the Core Documentation

#### Database EER

A full model of the EvShop database can be found in the `_db` directory at the root of the plugin. Please maintain the diagram when making changes to the database schema.

### Products Listing and Helpers

### Searching with product listing
If you want to search with the product listing method in the ProductsComponent then you will need to extend it and override the `_addAdditionalParamsToListing`.

If you are using the Evoluted Search plugin https://git.evoluted.net/evoluted-core-plugins/searchable then the following examples can be used to access the search index table through the listing.

First you will need to add an extra virtual field by extendig the ProductsComponent and overriding `_addVirtualFieldsToProductListing`:

	protected function _addVirtualFieldsToProductListing(&$Model, $orderData) {
		parent::_addVirtualFieldsToProductListing($Model, $orderData);

		if (isset($orderData['search']) && !empty($orderData['search'])) {
			$searchTerm = $orderData['search']['searchTerm'];
			$Model->virtualFields['relevance'] = "((MATCH(SearchIndex.data) AGAINST ('\"$searchTerm\"' IN BOOLEAN MODE) * 10)
				+ (MATCH(SearchIndex.data) AGAINST ('$searchTerm' IN BOOLEAN MODE) * 1.5))";
		}

		return;
	}

You will then need to add a join and order parameter to the listing query by overriding the `_addAdditionalParamsToListing`:

	protected function _addAdditionalParamsToListing(&$queryModel, $currentParams, $orderData) {
		//Go through the passed ordering parameters and add it to the pagination query
		$currentParams = parent::_addAdditionalParamsToListing($queryModel, $currentParams, $orderData);

		if (isset($orderData['search']) && !empty($orderData['search'])) {
			$currentParams = $this->_addSearchParamsToListing($currentParams, $orderData['search'], $queryModel);
		}

		return $currentParams;
	}

	protected function _addSearchParamsToListing($currentParams, $orderOptions, &$queryModel) {
		$searchTerm = $orderOptions['searchTerm'];

		$currentParams['joins'][] = [
			'table' => 'search_indices',
			'alias' => 'SearchIndex',
			'conditions' => [
				'SearchIndex.model' => 'EvShop.Product',
				'SearchIndex.association_key = Product.id',
				'OR' => [
					"MATCH(SearchIndex.data) AGAINST('\"$searchTerm\"' IN BOOLEAN MODE) > 0",
					"MATCH(SearchIndex.data) AGAINST('$searchTerm' IN BOOLEAN MODE) > 0"
				]
			]
		];

		if (isset($currentParams['order'])) {
			$currentParams['order'] .= ', Product.relevance DESC';
		} else {
			$currentParams['order'] = 'Product.relevance DESC';
		}

		return $currentParams;
	}

Then you will need to call the component and pass the search term in the order data as `['search']['searchTerm']`. You can also pass filter/sort params on the search page by using the `$orderData` or `$params` as normal e.g. if you want to paginate the search results.

#### Showing specific products

If you know the ids of the products you want to show, specify these in the order data (third parameter) as `['productIds'] = [$id1, $id2]`. This greatly enhances the efficiency of the query so it is recommended to use this over specifying product ids in the query params (first parameter).

#### Listing Helper

A couple of functions have been added to the ProductsHelper to fetch the information for displaying product prices. It is beneficial to use these instead of accessing the array directly as it makes it more extendable and future proof incase the arrays change.

You can find the full set of methods in the ProductsHelper but here is an example of using them:

	<?php if ($this->Products->isSalePrice($product)): ?>
		<span class="price sale">
			<?= $this->Products->getPrice($product); ?>
		</span>
		<span class="price">
			<?= $this->Products->getSalePrice($product, true); ?>
		</span>
	<?php else: ?>
		<span class="price">
			<?= $this->Products->getPrice($product); ?>
		</span>
	<?php endif; ?>

#### Getting Stock on the Listing Page

By default inventory isn't pulled out on the listing page but can be done with the following:

Override the ProductsComponent and the `_addAdditionalParamsToListing` method

	<?php

	App::uses('ProductsComponent', 'EvShop.Controller/Component');

	class EvShopProductsComponent extends ProductsComponent {

		/**
		 * Check if specific ordering data is provided and if so call the function that adds the correct parameters to the
		 * query. Extend to add add your own parameters to the listing query.
		 * @param array $currentParams The current parameters of the query to change. Normally the defaults set in listing()
		 * @param array $orderData     The ordering data (direction and currencyId if it is set)
		 * @param Model $queryModel    The model that is being queried on, listing uses Product
		 */
		protected function _addAdditionalParamsToListing(&$queryModel, $currentParams, $orderData) {
			parent::_addAdditionalParamsToListing($queryModel, $currentParams, $orderData);
			$queryModel->Variant->linkInventory();
			$currentParams['contain']['Variant']['Inventory'] = [];
			return $currentParams;
		}
	}

Add this method to your override ProductsHelper

	/**
	 * Used for the listing page, checks if a variant is in stock
	 * @param  $variants Variants passed from product listing
	 * @return boolean   Returns true if in stock
	 */
		public function inStock($variants) {
			$soldOutVariants = 0;
			$variantCount = 0;

			// Loop through each variant and set the price and saleprice
			foreach ($variants as $key => $Variant) {

				// Due to an after find the is elements in that are not variants
				if (!is_int($key)) {
					continue;
				}

				$variantCount++;

				// If the variant is not purchasable then set it to sold out
				if (isset($Variant['Inventory']) && empty($Variant['Inventory'])) {
					$soldOutVariants++;
				} else {

					//oos_action is stored as json string so needs to be decoded before being tested upon
					if (isset($Variant['Inventory']['oos_action']) && !is_array($Variant['Inventory']['oos_action'])) {
						$Variant['Inventory']['oos_action'] = json_decode($Variant['Inventory']['oos_action']);
					}

					if (!$this->Inventory->allowPurchase($Variant)) {
						$soldOutVariants++;
					}
				}

			}

			// Check if the amount of sold out variants is the same as the amount of variants
			if ($soldOutVariants != $variantCount) {
				return true;
			}

			return false;
		}

Then you can do

	<?php if (!$this->Products->inStock($variants)): ?>


### Category Controllers

In most shops, it's likely that it's the categories listing that is the main bit which will be modified. Some "stub" methods are defined within the categories controller which are used to pass array parameters to the find methods when on category / product listings as shown below.

	$this->set(
		array(
			'categoryListing' => $this->Categories->listingByParent(
				$id,
				$this->_processCategoryParams($data),
				false
			),
			'productListing' => $this->Products->listingByCategory(
				$this->categoryIds,
				$this->_processProductParams($data)
			)
		)
	);

This was used with great effect in Brighton Tools project to customise the category listing to also include a brand filter and to also amend the default ordering of products.

	protected function _processProductParams($Category) {
		$params = parent::_processProductParams($Category);

		if (! empty($this->request->params['named']['brand_id'])) {
			$params['conditions']['Product.brand_id'] = $this->request->params['named']['brand_id'];
		}

		$params['maxLimit'] = 1000000;

		$params['order'] = 'Product.created DESC, CategoriesProduct.sequence ASC, Product.name ASC';

		return $params;
	}

### Google Feed

Bundled with the plugin is a Google Feed Controller that is used to create a Google Xml product feed. This is automatically accessible via http://thesite.com/google-product-feed.xml

Unless there are specific requirements, the included setup should cover most cases where you require the feed, the only thing that needs to be done during setup is to set the Google Category for the products within the Config. The google categories can be found at <https://support.google.com/merchants/answer/1705911>. This will currently set the same Google category for each product. The internal Shop categories are set to the product at the `product_type` element where it will select the first category it returns (if multiple are selected).

#### Google Product Category

Google's merchant supports product categories. This entry can be defined globally using a CakePHP config variable `Configure::write('EvShop.googleFeed.category')` or on a per product category basis via the Google Product Category field in the admin (this field only displays for admin users).

### Google Product Brand

If a brands are being used or a brand hasn't been set then the fallback brand, set in the config `EvShop.googleFeed.Brand`, is used instead. This is usually the name of the site.

##Rebuilding foreign currencies
The shop supports automatically updating foreign prices. To do this you just need to make sure the autoManageCurrencies variable is set to true in your config (this has been intentionally left as a config variable instead of a site setting as it's highly unlikely that we want clients to be messing with this setting).

When this is enabled, on your variants, only pricing for your default currency will be shown. All other currencies will be automatically updated when you save the record.

###Updating via command line
A command line option is also provided to allow you to automatically update all product pricing in one go. This is generally useful if you want to update all foreign prices nightly so they match up with an up to date copy of the exchange rates.

To use the command line script, simply run:

	./app/Console/cake EvShop.UpdatePricing update

It's recommended that you update your currency exchange rates first. Instructions for the shell script that handles that can be found in the EvCurrency addon's readme file.


## Events

### EvShop.Model.Product.saved

Called in Products afterSave callback once variants have processed.

#### Parameters

* `newItem` - contains the boolean value from afterSaves created parameter.


### EvShop.Model.Variant.saved

Called in Variant afterSave callback.

#### Parameters

* `newItem` - contains the boolean value from afterSaves created parameter.

## Config settings

* googleFeedFilepath - The filepath to write the google product feed after it has been generated (default: "webroot/product_feed.xml")
* googleFeedUseFile  - Whether or not to use the generated google product feed (default: false)

## Promotions

As of version `2.6.15.0`, EvShop has a `ProductPromotionsController` which can list all products included in an `EvPromotion`. To make best use of this, set your `EvPromotion.actualRoute` in the `EvPromotion` config to `ev_shop/product_promotions/view/:primaryKey`.

## Product Caching

Product caching can be used to help lessen the loading time of a page. Currently only the optionPaths used to disable incompatible options are cached. This should be cleared automatically when:

* A product is saved
* A variant is saved
* A variant's price is updated
* An option group is updated (including options)
* A product or variant's inventory is updated
* A tax level changes
* A currency changes

To activate this feature, set up a cache configuration in bootstrap and then set `EvShop.productCacheName` to the name of the cache configuration in the config file.

