<?= $this->Html->css('EvShop.stockform', ['inline' => false]); ?>
<?= $this->Html->script('admin_form', ['inline' => false]); ?>

<h1>Manage Stock</h1><br>

<?= $this->Form->create() ?>

<div class='bs' id='stockform'>
	<?php foreach ($products as $product): ?>

		<div>
			<h2><?= $product['product_code'] ?> <?= $product['name'] ?></h2><br>
		</div>

		<?php if (count($product['TableOptionGroup']) == 0 ): ?>
			<table class='table'>
				<tr>
					<td>Stock</td>
					<td>
						<?php
							echo $this->Form->input(
								'Inventory.' . $product['Variant'][0]['Inventory']['id'] . '.stock',
								[
									'label' => false
								]
							);
							echo $this->Form->hidden('Inventory.' . $product['Variant'][0]['Inventory']['id'] . '.id');
						?>
					</td>
				</tr>
			</table>

		<?php elseif (count($product['TableOptionGroup']) == 1 ): ?>
			<table class='table'>
				<thead>
					<th>Variant</th>
					<th>Stock</th>
				</thead>
				<tbody>
					<?php foreach($product['Variant'] as $variant): ?>
						<tr>
							<td><?= $variant['name'] ?></td>
							<td><?php
								echo $this->Form->input(
									'Inventory.' . $variant['Inventory']['id'] . '.stock',
									[
										'label' => false
									]
								);
								echo $this->Form->hidden('Inventory.' . $variant['Inventory']['id'] . '.id');
							?></td>
						</tr>
					<?php endforeach ?>
				</tbody>
			</table>

		<?php elseif (!empty($product['Split'])): ?>
			<?php foreach ($product['Split'] as $splitProduct): ?>
				<h3><?= $splitProduct['name'] ?></h3>
				<div class='table-container'>
					<table class='table'>
						<thead>
							<th><?= $product['TableOptionGroup'][1]['name']?></th>
							<?php $first = true; foreach ($product['TableOptionGroup'][0]['Option'] as $option): ?>
								<th><?
									if ($first) {
										echo $product['TableOptionGroup'][0]['name'] . ': ' . $option['name'];
										$first = false;
									} else {
										echo $option['name'];
									}
								?></th>
							<?php endforeach ?>
						</thead>
						<tbody>
							<?php foreach($product['TableOptionGroup'][1]['Option'] as $optionRow): ?>
								<tr>
									<td><?= $optionRow['name'] ?></td>
									<?php foreach ($product['TableOptionGroup'][0]['Option'] as $optionCol): ?>
										<td>
											<?php
												echo $this->Form->input(
													'Inventory.' . $product['Variant'][$splitProduct['ids_prefix'] . '.' . $optionCol['id'] . '.' . $optionRow['id']]['Inventory']['id'] . '.stock',
													[
														'label' => false,
													]
												);
												echo $this->Form->hidden('Inventory.' . $product['Variant'][$splitProduct['ids_prefix'] . '.' . $optionCol['id'] . '.' . $optionRow['id']]['Inventory']['id'] . '.id');
											?>
										</td>
									<?php endforeach ?>
								</tr>
							<?php endforeach ?>
						</tbody>
					</table>
				</div>
			<?php endforeach ?>

		<?php else: ?>
			<div class='table-container'>
				<table class='table'>
					<thead>
						<th><?= $product['TableOptionGroup'][1]['name']?></th>
						<?php $first = true; foreach ($product['TableOptionGroup'][0]['Option'] as $option): ?>
								<th><?
									if ($first) {
										echo $product['TableOptionGroup'][0]['name'] . ': ' . $option['name'];
										$first = false;
									} else {
										echo $option['name'];
									}
								?></th>
							<?php endforeach ?>
					</thead>
					<tbody>
						<?php $first = true; foreach($product['TableOptionGroup'][1]['Option'] as $optionRow): ?>
							<tr>
								<td><?= $optionRow['name'] ?></td>
								<?php foreach ($product['TableOptionGroup'][0]['Option'] as $optionCol): ?>
									<td>
										<?php
											echo $this->Form->input(
												'Inventory.' . $product['Variant'][$optionCol['id'] . '.' . $optionRow['id']]['Inventory']['id'] . '.stock',
												[
													'label' => false,
												]
											);
											echo $this->Form->hidden('Inventory.' . $product['Variant'][$optionCol['id'] . '.' . $optionRow['id']]['Inventory']['id'] . '.id');
										?>

									</td>
								<?php endforeach ?>
							</tr>
						<?php endforeach ?>
					</tbody>
				</table>
			</div>
		<?php endif ?>


	<?php endforeach ?>

</div>

<div class="row">
	<div class="col-xs-12 col-sm-6">

		<?= $this->Form->button('<i class="fa fa-check"></i> Save', [
			'type' => 'submit',
			'class' => 'btn btn-primary submit'
		]); ?>

		<?= $this->Form->button('<i class="fa fa-check"></i> Save & Exit', [
			'type' => 'submit',
			'class' => 'btn btn-primary submit-exit'
		]); ?>

	</div>

	<div class="col-xs-12 col-sm-2 pull-right text-right">
		<?= $this->Html->link(
			'<i class="fa fa-times"></i> Cancel',
			[
				'action' => 'index'
			],
			[
				'escape' => false,
				'class' => 'btn btn-danger'
			]
		)?>
	</div>

<?= $this->Form->end() ?>

