<?php
App::uses('AppHelper', 'View/Helper');

class OptionsHelper extends AppHelper {

/**
 * Inject a tab into an admin form that allows options to be created/deleted/reordered.
 *
 * @return void.
 */
	public function injectAdminForm() {
		echo $this->element(
			'form_tab',
			array(
				'title' => 'Options',
				'tabContent' => $this->element('EvShop.Options/optionsTab')
			)
		);
	}

/**
 * Get field attributes for the name field on an option row in the options tab element.
 *
 * @param null|string|int $key      The array key of the option the field is for.
 *                                  Defaults to null when a new option is being created.
 * @param bool            $sortable True if options can be sorted. Defaults to false.
 * @param bool            $firstRow True if the field belongs to the first row. Defaults to false.
 * @return array.
 */
	public function getAdminOptionNameFieldAttributes($key = null, $sortable = false, $firstRow = false) {
		$attributes = [
			'type' => 'string',
			'class' => 'block-name',
			'after' => $this->getAdminOptionDeleteAndReorderLinks($key, $sortable),
			'disabled' => $firstRow,
			'label' => 'Option',
			'wrapInput' => 'col-xs-12 col-sm-2 col-md-6'
		];

		if (
			$key !== null
			&& !empty(Configure::read('EvShop.manageOptions'))
			&& !empty($this->_View->request->data['Option'][$key]['id'])
		) {
			// add link to the manage option admin edit template
			$attributes['displayInfo'] = $this->_View->Html->link(
				'Click to manage additional data for the product option',
				[
					'admin' => true,
					'plugin' => 'ev_shop',
					'controller' => 'options',
					'action' => 'edit',
					$this->_View->request->data['Option'][$key]['id']
				]
			);
		}

		return $attributes;
	}

/**
 * Get the links used in the admin option tab to delete and to reorder the option.
 *
 * @param null|string|int $key      The array key of the option the field is for.
 *                                  Defaults to null when a new option is being created.
 * @param bool            $sortable True if options can be sorted. Defaults to false.
 * @return string.
 */
	public function getAdminOptionDeleteAndReorderLinks($key = null, $sortable = false) {
		if ($key === null) {
			return '';
		}

		$deleteLink = '<div class="col-xs-12 col-sm-2 col-md-3">';

		if (empty($this->_View->request->data['Option'][$key]['is_used'])):
			$deleteLink .= '<a href="#" class="delete-item btn btn-sm btn-danger"><i class="fa fa-times"></i> Delete Field</a>';
		endif;

		if ($sortable) {
			$deleteLink .= '
				<a href="" class="s s--up">Up</a>
				<a href="" class="s s--down">Down</a>
			';
		}

		$deleteLink .= '</div>';

		return $deleteLink;
	}

/**
 * Get a list of options from an option group to create a list of selectable options to make variants from.
 *
 * @param array $optionGroup The option group to get options from.
 * @return array Formatted as {option id} => {option name}.
 */
	public function getAdminVariantListOptions($optionGroup) {
		return Hash::combine($optionGroup['Option'], '{n}.id', '{n}.name');
	}
}
