<?php
	$options = [];
	if (!empty($Variant['Option'])):
		$options = Hash::extract($Variant['Option'], '{n}.id');
	endif;
?>

<fieldset class="collapsable-fieldset<?=$open?> variant-record" data-variant="<?=$Variant['id']?>" data-options="<?=implode(",", $options)?>">
	<legend>
		<?= isset($Variant['name']) ? h($Variant['name']) : '' ?>
	</legend>

	<div class="container-fluid">
		<div class="row">
			<div class="col-xs-12 col-md-5">
				<?php
					echo $this->element(
						'EvShop.Variants/manage/variant-fields',
						[
							'key' => $key,
							'Variant' => $Variant,
						]
					);
				?>
			</div>

			<?php if (CakePlugin::loaded('EvInventory')): ?>
				<div class="col-xs-12 col-md-7 manage-stock-options">
					<?php
						echo $this->element(
							'EvShop.Variants/manage/inventory-actions',
							[
								'key' => $key,
								'Variant' => $Variant,
							]
						);
					?>
				</div>
			<?php endif; ?>
		</div>

		<?php if(! empty($currencies)): ?>
			<div class="row">
				<div class="col-xs-12">
					<?php foreach ($currencies as $currencyId => $currencyName): ?>
						<?php
							echo $this->element(
								'EvShop.Variants/manage/currency',
								[
									'key' => $key,
									'Variant' => $Variant,
									'currencyId' => $currencyId,
									'currencyName' => $currencyName,
								]
							);
						?>
					<?php endforeach; ?>
				</div>
			</div>
		<?php endif; ?>
	</div>
</fieldset>
