<?php
	/*
	 * Manually assign the variant name to a hidden field so it is submitted with other request data and returns on
	 * failed form submissions
	 */
	echo $this->Form->input(
		'Variant.' . $key . '.name',
		[
			'type' => 'hidden',
		]
	);

	if (isset($Variant['desc_temp'])) {
		$this->request->data['Variant'][$key]['option_desc'] = $Variant['desc_temp'];
	}

	//The fields in the following array are displayed manually so remove them from the field list.
	$removeFieldsArray = [
		'Variant.name',
		'Variant.sku',
		'Variant.gtin',
		'Variant.is_active',
	];

	// This template is used for the both the Pricing tab and the Variant editor.
	// Use $variantFields in pricing tab and $fields in variant editor
	$variantFields = !empty($variantFields) ? $variantFields : $fields;

	foreach ($variantFields as $field => $attr):
		if (in_array($field, $removeFieldsArray)):
			continue;
		endif;

		$attr['label']['class'] = 'col-xs-12 col-md-5 control-label';
		$attr['wrapInput'] = 'col-xs-12 col-md-7 form-control-readonly';

        echo $this->Form->addField(
            'Variant.' . $key . '.' . substr($field, strpos($field, '.') + 1),
            $attr
        );
	endforeach;

	echo $this->Form->addField(
		'Variant.' . $key . '.product_id',
		[
			'type' => 'hidden',
		]
	);

	//SKU field
	echo $this->Form->addField(
		'Variant.' . $key . '.sku',
		[
			'label' => [
				'class' => 'col-xs-12 col-md-5 control-label',
				'text' => 'SKU',
			],
			'type' => 'string',
			'wrapInput' => 'col-xs-12 col-md-7',
		]
	);

	//GTIN field
	echo $this->Form->addField(
		'Variant.' . $key . '.gtin',
		[
			'label' => [
				'class' => 'col-xs-12 col-md-5 control-label',
				'text' => 'GTIN',
			],
			'type' => 'string',
			'wrapInput' => 'col-xs-12 col-md-7',
		]
	);

	//Cost field
	$cost = null;
	if (isset($Variant['cost'])):
		$roundedPrice = $this->Number->precision($Variant['cost'], 3);
		if (substr(strval($roundedPrice), -1) == 0) {
			$cost = $this->Number->precision($Variant['cost'], 2);
		} else {
			$cost = $roundedPrice;
		}
	endif;

	echo $this->Form->addField(
		'Variant.' . $key . '.cost',
		[
			'label' => [
				'class' => 'control-label col-xs-12 col-md-5',
			],
			'type' => 'decimal',
			'value' => $cost,
			'wrapInput' => 'col-xs-12 col-md-7',
		]
	);

	if (CakePlugin::loaded('EvInventory')):
		echo $this->element(
			'EvShop.Variants/manage/inventory-fields',
			[
				'key' => $key,
				'Variant' => $Variant,
			]
		);
	endif;

	//Is active field
	echo $this->Form->addField(
		'Variant.' . $key . '.is_active',
		[
			'wrapInput' => 'col-xs-12 col-md-7 col-md-offset-5',
			'type' => 'boolean',
		]
	);

	echo $this->fetch('EvShop.Elements/Variants/manage/additional-fields');
?>
