<?php
	//If currencies are being auto managed and this isn't the default currency then don't display it
	if (
		Configure::read('EvShop.autoManageCurrencies') == true
		&& isset($defaultCurrency)
		&& $currencyId != $defaultCurrency
	):
		return;
	endif;

	//Taxrate is a required field so would always be set, check if tax is set higher than 0
	$taxRate = null;
	if (isset($Variant['Product']['TaxLevel']['rate']) && $Variant['Product']['TaxLevel']['rate'] > 0) {
		$taxRate = $Variant['Product']['TaxLevel']['rate'];
	}

	$taxLabelAsVat = Configure::read('EvShop.displayTaxAsVat');
	$taxLabel = 'Tax';
	if ($taxLabelAsVat) {
		$taxLabel = 'VAT';
	}

	$currencyInputAttr = [
		'type' => 'input',
		'value' => null,
		'label' => [
			'class' => 'col-xs-12 col-lg-6 control-label',
		],
		'wrapInput' => 'col-xs-12 col-lg-6',
		'data-type' => 'currency',
		'data-field' => null,
		'data-taxrate' => $taxRate,
		'data-currency' => $currencyId,
		'data-taxlabel' => $taxLabelAsVat,
	];

	$currencyLabelAttr = [
		'class' => 'col-xs-12 text-center',
	];

	$currencyClasses = 'col-xs-12 col-sm-6 col-md-4 col-lg-3 price-row';
?>

<div class="col-xs-12">
	<fieldset class="">
		<legend>
			Currency: <?php echo $currencyName; ?>
		</legend>

		<div class="container-fluid">
			<div class="row transition-none">
				<?php
					$priceId = null;
					if (isset($Variant['VariantPricing'][$currencyId]['id'])):
						$priceId = $Variant['VariantPricing'][$currencyId]['id'];
					endif;

					echo $this->Form->addField(
						'Variant.' . $key . '.VariantPricing.' . $currencyId . '.id',
						array(
							'type' => 'hidden',
							'value' => $priceId
						)
					);

					echo $this->Form->addField(
						'Variant.' . $key . '.VariantPricing.' . $currencyId . '.currency_id',
						array(
							'type' => 'hidden',
							'value' => $currencyId
						)
					);
				?>

				<div class="<?= $currencyClasses ?>">
					<?php
						$rrp = null;
						if (isset($Variant['VariantPricing'][$currencyId]['rrp'])):
							$roundedPrice = $this->Number->precision($Variant['VariantPricing'][$currencyId]['rrp'], 3);
							if (substr(strval($roundedPrice), -1) == 0) {
								$rrp = $this->Number->precision($Variant['VariantPricing'][$currencyId]['rrp'], 2);
							} else {
								$rrp = $roundedPrice;
							}
						endif;

						$rrpFieldAttr = $currencyInputAttr;
						$rrpFieldAttr['value'] = $rrp;
						$rrpFieldAttr['data-field'] = 'rrp';

						// multiple rrp fields required
						if ($taxRate !== null && $taxRate > 1):
							echo $this->Html->tag('label', 'RRP', $currencyLabelAttr);

							$rrpFieldAttr['label']['text'] = 'ex. ' . $taxLabel;
						else:
							$rrpFieldAttr['label']['text'] = 'RRP (ex. ' . $taxLabel . ')';
						endif;

						echo $this->Form->addField(
							'Variant.' . $key . '.VariantPricing.' . $currencyId . '.rrp',
							$rrpFieldAttr
						);
					?>
				</div>

				<div class="<?= $currencyClasses ?>">
					<?php
						$price = null;
						if (isset($Variant['VariantPricing'][$currencyId]['price'])):
							$roundedPrice = $this->Number->precision($Variant['VariantPricing'][$currencyId]['price'], 3);
							if (substr(strval($roundedPrice), -1) == 0) {
								$price = $this->Number->precision($Variant['VariantPricing'][$currencyId]['price'], 2);
							} else {
								$price = $roundedPrice;
							}
						endif;

						$priceFieldAttr = $currencyInputAttr;
						$priceFieldAttr['value'] = $price;
						$priceFieldAttr['data-field'] = 'price';

						// multiple rrp fields required
						if ($taxRate !== null && $taxRate > 1):
							echo $this->Html->tag('label', 'Price', $currencyLabelAttr);

							$priceFieldAttr['label']['text'] = 'ex. ' . $taxLabel;
						else:
							$priceFieldAttr['label']['text'] = 'Price (ex. ' . $taxLabel . ')';
						endif;

						echo $this->Form->addField(
							'Variant.' . $key . '.VariantPricing.' . $currencyId . '.price',
							$priceFieldAttr
						);
					?>
				</div>

				<div class="<?= $currencyClasses ?>">
					<?php
						$salePrice = null;
						if (isset($Variant['VariantPricing'][$currencyId]['sale_price'])):
							$roundedPrice = $this->Number->precision($Variant['VariantPricing'][$currencyId]['sale_price'], 3);
							if (substr(strval($roundedPrice), -1) == 0) {
								$salePrice = $this->Number->precision($Variant['VariantPricing'][$currencyId]['sale_price'], 2);
							} else {
								$salePrice = $roundedPrice;
							}
						endif;

						$salePriceFieldAttr = $currencyInputAttr;
						$salePriceFieldAttr['value'] = $salePrice;
						$salePriceFieldAttr['data-field'] = 'sale_price';

						// multiple rrp fields required
						if ($taxRate !== null && $taxRate > 1):
							echo $this->Html->tag('label', 'Sale Price', $currencyLabelAttr);

							$salePriceFieldAttr['label']['text'] = 'ex. ' . $taxLabel;
						else:
							$salePriceFieldAttr['label']['text'] = 'Sale Price (ex. ' . $taxLabel . ')';
						endif;

						echo $this->Form->addField(
							'Variant.' . $key . '.VariantPricing.' . $currencyId . '.sale_price',
							$salePriceFieldAttr
						);
					?>
				</div>

				<?php if (! empty(Configure::read('SiteSetting.ev_shop.enable_trade_pricing'))): ?>
					<div class="<?= $currencyClasses ?>">
						<?php
							$tradePrice = null;
                            if (isset($Variant['VariantPricing'][$currencyId]['trade_price'])):
                                $roundedPrice = $this->Number->precision($Variant['VariantPricing'][$currencyId]['trade_price'], 3);
								if (substr(strval($roundedPrice), -1) == 0) {
									$tradePrice = $this->Number->precision($Variant['VariantPricing'][$currencyId]['trade_price'], 2);
								} else {
									$tradePrice = $roundedPrice;
								}
                            endif;

                            $tradePriceFieldAttr = $currencyInputAttr;
							$tradePriceFieldAttr['value'] = $tradePrice;
							$tradePriceFieldAttr['data-field'] = 'trade_price';

							// multiple rrp fields required
							if ($taxRate !== null && $taxRate > 1):
								echo $this->Html->tag('label', 'Trade Price', $currencyLabelAttr);

								$tradePriceFieldAttr['label']['text'] = 'ex. ' . $taxLabel;
							else:
								$tradePriceFieldAttr['label']['text'] = 'Trade Price (ex. ' . $taxLabel . ')';
							endif;

                            echo $this->Form->addField(
                                'Variant.' . $key . '.VariantPricing.' . $currencyId . '.trade_price',
                                $tradePriceFieldAttr
                            );
						?>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</fieldset>
</div>
