<?php
	if (!isset($prefix)):
		$prefix = "";
	endif;

	$model = isset($model) ? $model : $primaryModel;

	// check if we are dealing with an overriden model
	$plugin = '';
	if (! is_null($primaryModelPlugin) && in_array($primaryModelPlugin, $plugins)):

		$plugin = $primaryModelPlugin;

	elseif ($model !== $actualModel):

		// loop the installed plugins and find out if our actual model starts with one of these
		foreach ($plugins as $pluginName):

			if (strpos($actualModel, $pluginName) === 0):

				$plugin = $pluginName;
			endif;

		endforeach;

	endif;

	// check to see if it's the main section
	$type = isset($type) ? $type : "VariantImage";

	if (!isset($imageSection) || $imageSection == 'main'):

		$type = 'VariantImage';
	else:

		$type = Inflector::camelize($imageSection."_variant_image");
		$prefix .= Inflector::camelize($imageSection);
	endif;

	if (!isset($images) && isset($this->data[$type])):

		$images = $this->data[$type];
	endif;

	// get all the fields we want to show
	$fields = false;
	$dataFields = false;
	if (is_array($imageSlots)):

		if (array_key_exists('dimensions', $imageSlots)):
			// Show recommended image upload size panel.
			if (array_key_exists('width', $imageSlots['dimensions']) && array_key_exists('height', $imageSlots['dimensions'])):
				if (!empty($imageSlots['dimensions']['element'])):
					$imageDimensions = $this->element($imageSlots['dimensions']['element'], $imageSlots['dimensions']);
				else:
					$imageDimensions = $this->element('Forms/image_dimensions', $imageSlots['dimensions']);
				endif;

				echo $imageDimensions;
			endif;
		endif;

		if (array_key_exists('fields', $imageSlots)):
			$fields = $imageSlots['fields'];
			if (is_array($fields)):
				$field_keys  = array();
				foreach ($fields as $key => $field):

					if (is_array($field)) {
						$field = $key;
					}

					$field_keys[] = $field;

				endforeach;

				$dataFields = implode(',', $field_keys);
			endif;
		endif;

		$imageSlots = $imageSlots['slots'];
	endif;

	$hasOptions = false;
	if (isset($options) && !empty($options)) {
		$hasOptions = true;
	}
?>

<div class="variant-image-info flash flash--condensed flash--info">
	<div class="flash__title">Variant Image Instructions</div>
	<div class="flash__text">
		<p>Once an image is restricted, the current product's selected options will appear. If no image options are selected then the image will not appear.</p>
		<p>If the current product has a set of options selected then the images below will be able to be set to only appear when those options are selected.</p>
	</div>
</div>

<div class="file-wrapper variant-image-wrapper"
	data-imageslots="<?php echo $imageSlots; ?>"
	data-model="<?php echo $model; ?>"
	data-plugin="<?php echo $plugin; ?>"
	data-type="<?php echo $type; ?>"
	data-prefix="<?php echo $prefix; ?>"
	data-fields="<?php echo $dataFields; ?>"
	data-hasoptions="<?php echo $hasOptions; ?>"
>
	<?php
		if (!isset($reorder)) {
			if ($imageSlots == 1) {
				$reorder = false;
			} else {
				$reorder = true;
			}
		}

		//var_dump($reorder);

		if (!empty($images)) {
			foreach($images as $key=>$image) {
				if (!empty($image['id'])) {
					echo $this->Element(
						'EvShop.VariantImages/image_field',
						array(
							'key' => $key,
							'prefix' => $prefix,
							'model' => $model,
							'plugin' => $plugin,
							'images' => $images,
							'type' => $type,
							'fields' => $fields,
							'reorder' => $reorder,
							'options' => $options
						)
					);
				}
			}
		}
	?>

</div>
<?php
	echo $this->Html->link(
		'<i class="fa fa-plus-circle"></i> New Image',
		"#",
		array(
			'escape' => false,
			'class' => 'add-new-variantImage btn--new-image btn btn-sm btn-success'
		)
	);
?>

<?php
	echo $this->Html->css(
		array(
			'EvShop.variantImage.css'
		),
		array(
			'inline' => false
		)
	);
?>
