<?php
$variantCount = count($data['Variant']);
foreach ($data['Variant'] as $key => $Variant):

	$name = $data['Product']['name'];
	if ($variantCount > 1):
		$name .= ': ' . $Variant['name'];
	endif;

	if (empty($Variant['sku'])):
		continue;
	endif;

	if (! empty($Variant['VariantPricing'])) {
		$variantPricing = array_shift($Variant['VariantPricing']);
	} else {
		continue;
	}

	$price = $variantPricing['price'];
	if (! empty($variantPricing['sale_price']) && $variantPricing['sale_price'] > '0.000000'):
		$price = $variantPricing['sale_price'];
	endif;

	$this->Html->scriptBlock(
	'{
		"@context": "http://schema.org/",
		"@type": "Product",
		"name": "' . h($name). '",
		"description": "' . strip_tags($data['Product']['description']) . '",
		"mpn": "' . h($Variant['sku']) . '",
		"brand": {
			"@type": "Thing",
			"name": "' . (! empty($data['Brand']['name']) ? h($data['Brand']['name']) : ' ') . '"
		},
		"offers": {
			"@type": "Offer",
			"priceCurrency": "GBP",
			"price": "' . number_format($price, 2, '.', '') . '"
		}
	}',
	array(
		'inline' => false,
		'type' => 'application/ld+json'
	));
endforeach;
?>