<table class="table table-striped table-bordered">
	<?php
	$tableCells = array();
	foreach ($data['Variant'] as $key => $Variant):

		$tableCells[$key][] = $this->Number->currency(
			$this->Products->singleVariantData('VariantPricing.0.rrp_incTax', $data),
			$currencies[CakeSession::read('EvCurrency.currencyId')]
		);
		$tableCells[$key][] = $this->Number->currency(
			$this->Products->singleVariantData('VariantPricing.0.price_incTax', $data),
			$currencies[CakeSession::read('EvCurrency.currencyId')]
		);

		$tableCells[$key][] = $this->Number->currency(
			$this->Products->singleVariantData('VariantPricing.0.sale_price_incTax', $data),
			$currencies[CakeSession::read('EvCurrency.currencyId')]
		);

		// Only load in trade pricing if the trade session exists.
		if (CakeSession::read('EvShop.isTrade') && Configure::read('SiteSetting.ev_shop.enable_trade_pricing') == '1'):
			if (Configure::read('SiteSetting.ev_shop.disable_tax_on_trade_pricing') == '1'):
				$tableCells[$key][] = $this->Number->currency(
					$this->Products->singleVariantData('VariantPricing.0.trade_price', $data),
					$currencies[CakeSession::read('EvCurrency.currencyId')]
				);
			else:
				$tableCells[$key][] = $this->Number->currency(
					$this->Products->singleVariantData('VariantPricing.0.trade_price_incTax', $data),
					$currencies[CakeSession::read('EvCurrency.currencyId')]
				);
			endif;
		endif;

		// only allow Inventory helper calls when the plugin is available and loaded
		if (CakePlugin::loaded('EvInventory')):
			if ($this->Inventory->allowPurchase($data['Variant']['0'])):
				$tableCells[$key][] = 'Add Form';
			else:
				$tableCells[$key][] = $this->Inventory->oosMessage();
			endif;

			if ($this->Inventory->showDelayedMessage($data['Variant']['0'])):
				$tableCells[$key][] = $this->Inventory->delayedMessage();
			endif;

			if ($this->Inventory->showLowStockMessage($data['Variant']['0'])):
				$tableCells[$key][] = $this->Inventory->lowStockMessage();
			endif;
		endif;

	endforeach;

	echo $this->Html->tableCells($tableCells);
	?>
</table>
