<?php
/**
 * ProductFixture
 *
 */
class ProductFixture extends CakeTestFixture {

	public $table = 'ev_shop_products';

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'primary'),
		'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
		'description' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
		'brand_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
		'tax_level_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
		'template_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10, 'unsigned' => false),
		'is_active' => array('type' => 'boolean', 'null' => true, 'default' => '0', 'comment' => 'actsAs CustomFields for extra site specific data'),
		'is_featured' => array('type' => 'boolean', 'null' => false, 'default' => '0'),
		'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1),
			'fk_products_brands_idx' => array('column' => 'brand_id', 'unique' => 0),
			'fk_products_tax_levels1_idx' => array('column' => 'tax_level_id', 'unique' => 0)
		),
		'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_general_ci', 'engine' => 'InnoDB')
	);

/**
 * Records
 *
 * @var array
 */
	public $records = array(
		array(
			'id' => 1,
			'name' => 'My Product 1',
			'description' => 'Lorem ipsum dolor sit amet, aliquet feugiat. Convallis morbi fringilla gravida, phasellus feugiat dapibus velit nunc, pulvinar eget sollicitudin venenatis cum nullam, vivamus ut a sed, mollitia lectus. Nulla vestibulum massa neque ut et, id hendrerit sit, feugiat in taciti enim proin nibh, tempor dignissim, rhoncus duis vestibulum nunc mattis convallis.',
			'brand_id' => 2,
			'tax_level_id' => 1,
			'template_id' => 1,
			'is_active' => 1,
			'is_featured' => 0,
			'created' => '2015-07-09 14:20:55',
			'modified' => '2015-07-09 14:20:55'
		),
		array(
			'id' => 2,
			'name' => 'My Product 2',
			'description' => 'Second product',
			'brand_id' => 1,
			'tax_level_id' => 1,
			'template_id' => 1,
			'is_active' => 1,
			'is_featured' => 1,
			'created' => '2015-07-09 14:20:55',
			'modified' => '2015-07-09 14:20:55'
		),
		array(
			'id' => 3,
			'name' => 'My in-active product 3',
			'description' => 'third product',
			'brand_id' => 1,
			'tax_level_id' => 1,
			'template_id' => 1,
			'is_active' => 0,
			'is_featured' => 0,
			'created' => '2015-07-09 14:20:55',
			'modified' => '2015-07-09 14:20:55'
		)
	);

}
