<?php
/**
 * CategoryFixture
 *
 */
class CategoryFixture extends CakeTestFixture {

	public $table = 'ev_shop_categories';

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'primary'),
		'parent_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10, 'unsigned' => false),
		'lft' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false),
		'rght' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false),
		'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
		'body' => array('type' => 'text', 'null' => true, 'default' => null, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
		'template_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 10, 'unsigned' => false),
		'is_active' => array('type' => 'boolean', 'null' => true, 'default' => '0'),
		'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1)
		),
		'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_general_ci', 'engine' => 'InnoDB')
	);

/**
 * Records
 *
 * @var array
 */
	public $records = array(
		array(
			'id' => 1,
			'parent_id' => null,
			'lft' => 1,
			'rght' => 2,
			'name' => 'Category 1',
			'body' => 'Lorem ipsum dolor sit amet',
			'template_id' => 1,
			'is_active' => 1,
			'created' => '2015-07-09 14:18:46',
			'modified' => '2015-07-09 14:18:46'
		),
		array(
			'id' => 2,
			'parent_id' => null,
			'lft' => 7,
			'rght' => 8,
			'name' => 'Category 2',
			'body' => 'Lorem ipsum dolor sit amet',
			'template_id' => 1,
			'is_active' => 1,
			'created' => '2015-07-09 14:18:46',
			'modified' => '2015-07-09 14:18:46'
		),
		array(
			'id' => 3,
			'parent_id' => null,
			'lft' => 3,
			'rght' => 6,
			'name' => 'Category 3',
			'body' => 'Lorem ipsum dolor sit amet',
			'template_id' => 1,
			'is_active' => 1,
			'created' => '2015-07-09 14:18:46',
			'modified' => '2015-07-09 14:18:46'
		),
		array(
			'id' => 4,
			'parent_id' => 3,
			'lft' => 4,
			'rght' => 5,
			'name' => 'Category 3 Sub Category 1',
			'body' => 'Lorem ipsum dolor sit amet',
			'template_id' => 1,
			'is_active' => 1,
			'created' => '2015-07-09 14:18:46',
			'modified' => '2015-07-09 14:18:46'
		)
	);

}
