<?php
App::uses('AppController', 'Controller');
App::uses('CakeRequest', 'Network');
App::uses('CakeResponse', 'Network');
App::uses('ComponentCollection', 'Controller');
App::uses('BrandsComponent', 'EvShop.Controller/Component');

// A fake controller to test against
class BrandsControllerTest extends AppController {

}


class BrandsComponentTest extends CakeTestCase {

	public $BrandsComponent = null;

	public $Controller = null;

	/**
	 * Fixtures
	 *
	 * @var array
	 */
	public $fixtures = array(
		'plugin.EvCore.image',
		'plugin.EvCustomFields.fields',
		'plugin.EvCustomFields.field_data',
		'plugin.MetaData.meta_data',
		'plugin.EvShop.product',
		'plugin.EvShop.brand',
		'plugin.EvShop.variant',
		'plugin.EvShop.category',
		'plugin.EvShop.categories_product'
	);

	/**
	 * setUp method
	 *
	 * @return void
	 */
	public function setUp() {
		parent::setUp();
		// Setup our component and fake test controller
		$Collection = new ComponentCollection();
		$this->BrandsComponent = new BrandsComponent($Collection);
		$CakeRequest = new CakeRequest();
		$CakeResponse = new CakeResponse();
		$this->Controller = new BrandsControllerTest($CakeRequest, $CakeResponse);
		$this->Controller->constructClasses();

		$this->BrandsComponent->initialize($this->Controller);
	}

	/**
	 * tearDown method
	 *
	 * @return void
	 */
	public function tearDown() {
		parent::tearDown();
		// Clean up after we're done
		unset($this->BrandsComponent);
		unset($this->Controller);
	}

	public function testListingReturnsAllActiveCategoriesAndDataWithNoParamsPassedAndWhenPagingDisabled() {
		$expected = array(
			array(
				'Brand' => array(
					'id' => '1',
					'name' => 'My Brand 1',
					'body' => 'Lorem ipsum dolor sit amet, aliquet feugiat. Convallis morbi fringilla gravida, phasellus feugiat dapibus velit nunc, pulvinar eget sollicitudin venenatis cum nullam, vivamus ut a sed, mollitia lectus. Nulla vestibulum massa neque ut et, id hendrerit sit, feugiat in taciti enim proin nibh, tempor dignissim, rhoncus duis vestibulum nunc mattis convallis.',
					'sequence' => '1',
					'is_active' => true,
					'template_id' => '1',
					'created' => '2015-07-09 14:17:49',
					'modified' => '2015-07-09 14:17:49'
				),
				'LogoImage' => array()
			),
			array(
				'Brand' => array(
					'id' => '2',
					'name' => 'My Brand 2',
					'body' => 'Lorem ipsum dolor sit amet, aliquet feugiat. Convallis morbi fringilla gravida, phasellus feugiat dapibus velit nunc, pulvinar eget sollicitudin venenatis cum nullam, vivamus ut a sed, mollitia lectus. Nulla vestibulum massa neque ut et, id hendrerit sit, feugiat in taciti enim proin nibh, tempor dignissim, rhoncus duis vestibulum nunc mattis convallis.',
					'sequence' => '2',
					'is_active' => true,
					'template_id' => '1',
					'created' => '2015-07-09 14:17:49',
					'modified' => '2015-07-09 14:17:49'
				),
				'LogoImage' => array()
			)
		);

		$this->assertEquals(
			$expected,
			$this->BrandsComponent->listing()
		);

		$this->assertEquals(
			$expected,
			$this->BrandsComponent->listing(array(), false)
		);
	}
}
