<?php

App::uses('EvShopAppModel', 'EvShop.Model');

class ProductAttributeGroup extends EvShopAppModel {

	public $validate = [
		'name' => [
			'notEmpty' => [
				'rule' => ['notBlank'],
				'message' => 'You must enter a name'
			],
		],
	];

	public $hasMany = [
		'ProductAttribute' => [
			'className' => 'EvShop.ProductAttribute'
		]
	];

/**
 * Bring in the product attributes in this group
 *
 * @param int $id The group id
 * @param array $query Any additional options
 * @return array
 */
	public function readForEdit($id, $query = []) {
		$query = Hash::merge($query, [
			'contain' => [
				'ProductAttribute'
			]
		]);

		return parent::readForEdit($id, $query);
	}

/**
 * {@inheritDoc}
 */
	public function beforeSave($options = []) {
		$beforeSave = parent::beforeSave($options);

		if ($beforeSave === false) {
			return false;
		}

		if (
			isset($this->data[$this->alias]['system_name'])
			&& empty($this->data[$this->alias]['system_name'])
		) {
			$this->data[$this->alias]['system_name'] = null;
		}

		return true;
	}

/**
 * Called after each successful save operation.
 *
 * @param bool $created True if this save created a new record
 * @param array $options Options passed from Model::save().
 * @return void
 * @link http://book.cakephp.org/2.0/en/models/callback-methods.html#aftersave
 * @see Model::save()
 */
	public function afterSave($created, $options = array()) {
		parent::afterSave($created, $options);

		// clear the cache used on the site option group filter listing
		Cache::delete('ev_shop_attribute_groups');

		// Clear the product cache
		$this->ProductAttribute->Product->clearCache();
	}
}
