<?php

App::uses('EvShopAppModel', 'EvShop.Model');

class ProductAttribute extends EvShopAppModel {

	public $validate = [
		'name' => [
			'notEmpty' => [
				'rule' => ['notBlank'],
				'message' => 'You must enter a name'
			],
		],
	];

	public $hasAndBelongsToMany = [
		'Product' => [
			'className' => 'EvShop.Product',
			'joinTable' => 'ev_shop_product_attributes_products'
		],
		'CategoryOverride' => [
			'className' => 'EvShop.CategoryOverride',
			'with' => 'EvShop.CategoryOverridesProductAttribute',
			'unique' => 'keepExisting',
		],
	];

	public $belongsTo = [
		'ProductAttributeGroup' => [
			'className' => 'EvShop.ProductAttributeGroup'
		]
	];

}
