<?php
App::uses('EvShopAppModel', 'EvShop.Model');
App::uses('ArrayUtil', 'EvCore.Lib');
/**
 * OptionGroup Model
 *
 * @property Option $Option
 */
class OptionGroup extends EvShopAppModel {

	public $displayName = 'Options';

	/**
	 * Display field
	 *
	 * @var string
	 */
	public $displayField = 'name';

	/**
	 * Validation rules
	 *
	 * @var array
	 */
	public $validate = array(
		'name' => array(
			'notEmpty' => array(
				'rule' => array('notBlank'),
				'message' => 'An option group must be entered'
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

	/**
	 * hasMany associations
	 *
	 * @var array
	 */
	public $hasMany = array(
		'Option' => array(
			'className' => 'EvShop.Option',
			'cascade' => true,
			'dependent' => true
		)
	);

	/**
	 * Query used to retrieve a record ready for edit
	 *
	 * @param integer $id ID of row to edit
	 * @param array $query The db query array - can be used to pass in additional parameters such as contain
	 * @return array
	 */
	public function readForEdit($id, $query = array()) {
		$query['contain']['Option'] = array(
			'order' => 'Option.sequence ASC'
		);

		return parent::readForEdit($id, $query);
	}

	/**
	 * Called after each successful save operation.
	 *
	 * @param bool $created True if this save created a new record
	 * @param array $options Options passed from Model::save().
	 * @return void
	 * @link http://book.cakephp.org/2.0/en/models/callback-methods.html#aftersave
	 * @see Model::save()
	 */
	public function afterSave($created, $options = array()) {
		parent::afterSave($created, $options);

		// clear the cache used on the site option group filter listing
		Cache::delete('option_groups');

		// Clear the product cache
		$this->Option->Variant->Product->clearCache();

		// process any custom field deletions
		if (! empty($this->data[$this->alias]['Options']['toDelete'])) {

			$ids = explode(',', $this->data[$this->alias]['Options']['toDelete']);
			$ids = ArrayUtil::clearArray($ids);

			$this->Option->deleteAll(
				array(
					'Option.id' => $ids
				),
				true,
				true
			);
		}
	}

	/**
	 * get all the option groups and options for selection
	 * within a product
	 *
	 * @return 	array
	 */
	public function getForSelection() {
		return $this->find(
			'all',
			array(
				'order' => 'OptionGroup.name ASC',
				'contain' => array(
					'Option' => array(
						'order' => 'Option.sequence ASC'
					)
				)
			)
		);
	}
}
