<?php

App::uses('AppModel', 'Model');

class EvShopAppModel extends AppModel {

	//Prefix with name of plugin to stop conflicts
	public $tablePrefix = "ev_shop_";

	public $plugin = 'EvShop';

	public $variantImageSlots = 0;

/**
 * Initialises the associated models such as Image, Document and Block
 *
 * @return void.
 */
	public function initialiseAssociateModels() {
		// Set up model associations for images automagically based on the
		// image slots.
		$this->_associateModels('EvShop.VariantImage', $this->variantImageSlots);

		parent::initialiseAssociateModels();
	}

/**
 * Base code for retrieving a single record for edit or view
 *
 * @param int   $id    ID of row to edit
 * @param array $query The db query array - can be used to pass in additional parameters such as contain
 * @return array
 */
	protected function _getItem($id, $query = array()) {
		$query = array_merge_recursive($query, $this->_containAssociateModel('VariantImage', $this->variantImageSlots));

		$data = parent::_getItem($id, $query);

		return $data;
	}

}
