<?php

App::uses('CakeEventListener', 'Event');

class EvShopTaxLevelUpdatedListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvTax.TaxLevel.Saved' => 'onTaxUpdated',
		);
	}

/**
 * Clear the product cache as all prices could have changed
 */
	public function onTaxUpdated(CakeEvent $event) {
		$data = $event->data['data'];

		$Product = EvClassRegistry::init('EvShop.Product');
		$affectedProductIds = $Product->find('list', [
			'fields' => [
				'id',
			],
			'conditions' => [
				'tax_level_id' => $data['TaxLevel']['id']
			]
		]);

		foreach ($affectedProductIds as $productId) {
			$Product->clearCache($productId);
		}

		return true;
	}
}
