<?php

App::uses('CakeEventListener', 'Event');

class EvShopInventoryUpdatedListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvInventory.Inventory.Saved' => 'onInventoryUpdated',
		);
	}

/**
 * Clear the product cache as all prices could have changed
 */
	public function onInventoryUpdated(CakeEvent $event) {
		$data = $event->data['data'];

		if (!empty(Configure::read('EvShop.productCacheName'))) {
			switch($data['Inventory']['model']) {
				case 'EvShop.Variant':
					$Variant = EvClassRegistry::init('EvShop.Variant');
					$productId = $Variant->field('product_id', ['Variant.id' => $data['Inventory']['model_id']]);
					if (!empty($productId)) {
						$Variant->Product->clearCache($productId);
					}
					break;
				case 'EvShop.Product':
					// Delete the product cache using the product ID
					$Product = EvClassRegistry::init('EvShop.Product');
					$Product->clearCache($data['Inventory']['model_id']);
					break;
			}
		}
		return true;
	}
}
