<?php

App::uses('CakeEventListener', 'Event');

class EvShopCurrencyUpdatedListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'Model.afterToggle' => 'checkModel',
			'EvCurrency.currencyUpdated' => 'updatePrices',
		);
	}

	public function checkModel(CakeEvent $event) {
		if ($event->data['model']->alias == 'Currency') {
			return $this->updatePrices($event);
		}
		return true;
	}

/**
 * Update the pricing of each variant whenever a currency changes
 */
	public function updatePrices(CakeEvent $event) {
		if (Configure::read('EvShop.autoManageCurrencies')) {

			// Check that there's not already a currency update task queued
			$QueuedTask = EvClassRegistry::init('Queue.QueuedTask');
			$existingJob = $QueuedTask->find('first', [
				'conditions' => [
					'fetched' => null,
					'jobType' => 'UpdatePricing'
				]
			]);

			if (empty($existingJob)) {
				$QueuedTask->createJob('UpdatePricing');
			}
		}

		$Product = EvClassRegistry::init('EvShop.Product');
		$Product->clearCache();

		return true;
	}
}
