<?php

App::uses('CakeEventListener', 'Event');
App::uses('DiscountLib', 'EvDiscount.Lib');

class EvShopCheckForDiscountRestrictionsListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvBasket.Component.BasketItem.CheckDiscountRestrictions' => 'checkForDiscountRestrictions',
		);
	}

	/**
	 * rebuild discount due to basket amends
	 *
	 * @param 	CakeEvent
	 */
	public function checkForDiscountRestrictions(CakeEvent $Event) {
		if (!empty($Event->result)) {
			//Default to past restriction result
			$result = $Event->result;
		} else {
			// Default to invalidating the discount
			$result = [];
		}

		if (
			empty($Event->data['discount']['code_restrictions']) ||
			empty($Event->data['basket_item'])
		) {
			return $result;
		}

		// Restrictions were found. Check to see if they are for the shop
		$basketItem = $Event->data['basket_item'];
		$discount = $Event->data['discount'];

		// Get the product id for basket item
		if ($basketItem['model'] == 'EvShop.Variant') {
			if (isset($basketItem['Variant']['Product'])) {
				$productId = $basketItem['Variant']['Product']['id'];
				$brandId = $basketItem['Variant']['Product']['brand_id'];
			}
		} elseif ($basketItem['model'] == 'EvShop.Product') {
			$productId = $basketItem['model_id'];

			if (isset($basketItem['Product'])) {
				$brandId = $basketItem['Product']['brand_id'];
			}
		}

		if (empty($productId)) {
			return $result;
		}

		// We've now got a list of product ids in the basket. Now we need to go through each code restriction
		// and work out if it applies to any of the products in the basket.
		foreach ($discount['code_restrictions'] as $restriction) {
			if ($restriction['model'] == 'EvShop.Product') {
				$result = array(
					'discountValue' => ($productId === $restriction['model_id']),
				);
			} elseif ($restriction['model'] == 'EvShop.Brand') {
				// Check if the brand applies to any of the products
				if (
					! empty($brandId) &&
					! empty($restriction['model_id'])
				) {
					// when a brand discount has been requested, fetch the brand id and
					// all child brand ids associated with it
					$Brand = EvClassRegistry::init('EvShop.Brand');

					$allowedChildBrandIds = $Brand->find('list', array(
						'conditions' => array(
							$Brand->alias . '.parent_id' => $restriction['model_id'],
							$Brand->alias . '.is_active' => true
						),
					));

					if (
						$brandId == $restriction['model_id'] ||
						isset($allowedChildBrandIds[$brandId])
					) {
						// It's a match - we allow the product to be discounted.
						$result = array(
							'discountValue' => true
						);
					} else {
						$result = array(
							'discountValue' => false
						);
					}
				}
			} elseif ($restriction['model'] == 'EvShop.Category') {

				$Category = EvClassRegistry::init('EvShop.Category');
				$parentCategory = $Category->findById($restriction['model_id']);

				// Get the list of categories the product is directly associated with that are under the parent category (includes parent)
				$matchingCategories = $Category->CategoriesProduct->find('list', [
					'fields' => [
						'CategoriesProduct.category_id',
						'CategoriesProduct.category_id',
					],
					'conditions' => [
						'CategoriesProduct.product_id' => $productId
					],
					'joins' => [
						[
							'table' => 'ev_shop_categories',
							'alias' => 'Category',
							'type' => 'Inner',
							'conditions' => [
								'Category.id = CategoriesProduct.category_id',
								'Category.lft >= ' => $parentCategory['Category']['lft'],
								'Category.rght <= ' => $parentCategory['Category']['rght'],
							]
						]
					]
				]);

				// If any categories exist then this product should be discount
				$result = array(
					'discountValue' => !empty($matchingCategories)
				);
			}

			//If a basket item passes any of the restrictions then we don't need to check any of the others.
			if (!empty($result['discountValue'])) {
				break;
			}
		}

		return $result;
	}
}
