<?php

App::uses('AuditLogPresenter', 'EvAuditLog.Lib');

class ProductAuditLogPresenter extends AuditLogPresenter {

/**
 * The property name is the name of the database field that changed. This method turns the field name
 * into something readable.
 *
 * @param array $audit      The audit data.
 * @param array $auditDelta The aduit delta array.
 * @return string Humanised property name.
 */
	public function presentPropertyName($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'brand_id':
				return 'Brand';
			case 'tax_level_id':
				return 'Tax Level';
			case 'template_id':
				return 'Template';
			default:
				return InflectorExt::humanize($auditDelta['property_name']);
		}
	}

/**
 * Present a audit delta value. If the value is null return an empty string. If the model is present
 * on the audit then an attempt to use a plugin presenter will occur, otherwise the value is returned
 * without any modification.
 *
 * @param array $audit      The audit data.
 * @param array $auditDelta The aduit delta array.
 * @param string $value 	The default value
 * @return string The value to present.
 */
	public function presentValue($audit, $auditDelta, $value) {
		switch ($auditDelta['property_name']) {
			case 'brand_id':
				$value = $this->_lookupValue('EvShop.Brand', $value);
				break;
			case 'tax_level_id':
				$value = $this->_lookupValue('EvTax.TaxLevel', $value);
				break;
			case 'template_id':
				$value = $this->_lookupValue('EvTemplates.Template', $value);
				break;
			case 'is_active':
				$value = $this->_presentBoolean($value);
				break;
		}

		return parent::presentValue($audit, $auditDelta, $value);
	}

/**
 * If the property should appear in the log
 *
 * @param array $audit The audit data
 * @param array $auditDelta The delta data
 * @return bool True if it should appear, false if not
 */
	public function shouldPresentProperty($audit, $auditDelta) {
		switch ($auditDelta['property_name']) {
			case 'id':
				return false;
			default:
				return parent::shouldPresentProperty($audit, $auditDelta);
		}
	}
}
