<?php

App::uses('ImagesController', 'EvCore.Controller');

class VariantImagesController extends ImagesController {

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'ajax_displayNew',
			'ajax_displayNewMultiple'
		));

		return;
	}

	/**
 	* Add a new image slot via AJAX.
 	*
 	* @param string $model The model to link the image to e.g. Page
 	* @param integer $key Image slot number
 	* @param string $type
 	* @param string $prefix Used when embedding images multiple levels deep e.g. Hotel.Room.0.Image
 	* @param string $plugin
 	* @param string $fields 	Comma separated list of fields
 	*/
	public function ajax_add($model, $key = 0, $type = 'Image', $prefix = "", $plugin = "", $itemFields = "") {
		$slotType = str_replace("VariantImage", "", $type);

		if ($prefix == "" || $prefix == "false") {
			$prefix = $slotType;
		}

		if ($slotType == "") {
			$slotType = 'main';
		}

		if (! empty($plugin) && $plugin !== 'false') {
			$this->loadModel($plugin . "." . $model);
		} else {
			$this->loadModel($model);
		}

		$fields = false;
		if (! empty($itemFields) && $itemFields !== "false") {

			$fields = explode(',', $itemFields);
		} else {
			if (
				isset($this->$model->imageSlots[Inflector::underscore($slotType)])
			) {
				if (
					is_array($this->$model->imageSlots[Inflector::underscore($slotType)])
					&& array_key_exists('fields', $this->$model->imageSlots[Inflector::underscore($slotType)])
				) {
					$fields = $this->$model->imageSlots[Inflector::underscore($slotType)]['fields'];
				} elseif (
					! is_array($this->$model->imageSlots[Inflector::underscore($slotType)])
					&& ! empty($this->$model->imageSlots[Inflector::underscore($slotType)])
				) {
					$fields = $this->$model->imageSlots[Inflector::underscore($slotType)];
				}
			}
		}

		if (isset($this->{$model}->imageSlots[Inflector::underscore($slotType)]['fields']) && is_array($fields)) {
			$availableFields = $this->{$model}->imageSlots[Inflector::underscore($slotType)]['fields'];
			// Check the model to see if any of the fields have custom field settings defined.
			foreach ($fields as $fieldKey => $field) {

				if (isset($availableFields[$field]) && is_array($availableFields[$field])) {
					unset($fields[$fieldKey]);
					$fields[$field] = $availableFields[$field];

				}
			}
		}

		//Set product options
		$this->set('options', []);

		$this->set(compact('model', 'prefix', 'key', 'type', 'fields'));
		$this->theme = "Admin";
		$this->render('EvShop.ajax_add', 'ajax');

		return;
	}

/**
 * Ajax method that returns a json encoded html image element of a specific image.
 * @param  string $filename The filename of the image being loaded.
 * @param  int    $fileId   The file ID of the image being loaded.
 * @return json             The json string containing the html image element
 */
	public function ajax_displayNew($filename, $fileId) {
		$this->set('imageFilename', $filename);
		$this->set('imageFileId', $fileId);

		$this->render('EvShop.ajax_display_new', 'ajax');
	}

/**
 * Ajax method that returns a json encoded array of html image elements of a specific variant. It will only return the
 * restricted images for the variant. The imageAttachment is used to find a specific set of variant images so if you
 * have multiple types of variant images it will need to be called multiple times.
 * @param  int    $variantId       The ID of the variant to retrieve images for.
 * @param  string $imageAttachment The attachment type of the images to retrieve e.g. "GalleryVariantImage"
 * @return json                    A json array containing html strings of image elements
 */
	public function ajax_displayNewMultiple($variantId, $imageAttachment) {
		$variant = EvClassRegistry::init('EvShop.Variant')->find(
			'first',
			[
				'conditions' => [
					'Variant.id' => $variantId
				]
			]
		);

		if (!empty($variant['Variant']['product_id'])) {
			$product = EvClassRegistry::init('EvShop.Product')->readForView($variant['Variant']['product_id']);

			$variant = (!empty($product['Variant'])) ? Hash::extract($product, 'Variant.{n}[id=' . $variantId . ']')[0] : false;

			$this->set('product', $product);
			$this->set('variant', $variant);
		}

		$this->set('imageAttachment', $imageAttachment);

		$this->render('EvShop.VariantImages/ajax_display_new_multi', 'ajax');
	}
}
