<?php

App::uses('EvShopAppController', 'EvShop.Controller');

class ProductPromotionsController extends EvShopAppController {

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow([
			'view'
		]);
	}

/**
 * Override to add additional parameters to the listing
 */
	protected function _addAdditionalParamsToListing(&$listingParams) {
	}

/**
 * Override to add additional parameters to the listing filters
 */
	protected function _addAdditionalFilterParamsToListing(&$filterParams) {
	}

/**
 * Override to set additional view variables based on the current listing
 */
	protected function _addAdditionalDataToView($listingParams, $filterParams, $productListing) {
	}

/**
 * Lists all products in a promotion.
 */
	public function view($id = null) {
		if (!CakePlugin::loaded('EvPromotion')) {
			throw new NotFoundException();
		}

		$Promotion = EvClassRegistry::init('EvPromotion.Promotion');
		$promotion = $Promotion->findActive($id, [
			'contain' => [
				'CodeRestriction'
			]
		]);

		if (empty($promotion)) {
			throw new NotFoundException();
		}

		$promotion = $promotion[0];
		$this->set('data', $promotion);

		$listingParams = [];
		$categoryConditions = [];

		$Category = EvClassRegistry::init('EvShop.Category');

		foreach ($promotion['CodeRestriction'] as $restriction) {

			switch ($restriction['model']) {
				case 'EvShop.Brand':
					$listingParams['conditions']['or']['Product.brand_id'][] = $restriction['model_id'];
					break;

				case 'EvShop.Product':
					$listingParams['conditions']['or']['Product.id'][] = $restriction['model_id'];
					break;

				case 'EvShop.Category':
					$category = $Category->findById( $restriction['model_id'] );
					$categoryConditions[] = [
						'PromoCategory.lft >= ' => $category['Category']['lft'],
						'PromoCategory.rght <= ' => $category['Category']['rght'],
					];
					break;
			}
		}

		if (!empty($categoryConditions)) {
			$categoryJoins = [
				[
					'table' => 'ev_shop_categories_products',
					'type' => 'inner',
					'alias' => 'PromoCategoryProduct',
					'conditions' => [
						'Product.id = PromoCategoryProduct.product_id',
					]
				],
				[
					'table' => 'ev_shop_categories',
					'type' => 'inner',
					'alias' => 'PromoCategory',
					'conditions' => [
						'PromoCategory.id = PromoCategoryProduct.category_id',
					]
				],
			];
			if (!isset($listingParams['joins'])) {
				$listingParams['joins'] = [];
			}
			if (!isset($listingParams['conditions']['or'])) {
				$listingParams['conditions']['or'] = [];
			}
			$listingParams['joins'] += $categoryJoins;
			$listingParams['conditions']['or'] += $categoryConditions;
		}

		$filterParams = [];

		// Allow overriding the query from a subclass
		$this->_addAdditionalParamsToListing($listingParams);
		$this->_addAdditionalFilterParamsToListing($filterParams);

		$productListing = $this->Products->listing( $listingParams, true, $filterParams );
		$this->set( 'productListing', $productListing );

		$this->_addAdditionalDataToView( $listingParams, $filterParams, $productListing );

		$this->view = 'EvShop.../Templates/ProductPromotions/view';
	}

}
