<?php

App::uses('EvShopAppController', 'EvShop.Controller');

class ProductAttributeGroupsController extends EvShopAppController {

/**
 * Hide the system name field from non-admins
 *
 * @return array
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		if (!$this->Permissions->hasSuperAdminPermission($this->Auth->user())) {
			unset($fields[$this->{$this->modelClass}->alias . '.system_name']);
		}

		return $fields;
	}

/**
 * Handle product attributes
 *
 * @param int $id The id to edit
 * @return void
 */
	public function admin_edit($id = null) {
		//
		if ($this->request->is('post') || $this->request->is('put')) {
			// Delete any removed attributes
			if (!empty($this->request->data['ProductAttribute']['to_delete'])) {
				$this->ProductAttributeGroup->ProductAttribute->deleteAll([
					'ProductAttribute.id' => explode(',', $this->request->data['ProductAttribute']['to_delete'])
				]);
				unset($this->request->data['ProductAttribute']['to_delete']);
			}

			// Remove any blank attributes
			foreach (array_keys($this->request->data['ProductAttribute']) as $key) {
				if (empty($this->request->data['ProductAttribute'][$key]['name'])) {
					unset($this->request->data['ProductAttribute'][$key]);
				}
			}
		}

		parent::admin_edit($id);
		$this->view = 'EvShop.admin_form';
	}
}
