<?php

App::uses('EvShopAppController', 'EvShop.Controller');

class OptionsController extends EvShopAppController {

/**
 * Used to populate form drop down selects.
 *
 * @return void.
 */
	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		$Model = $this->{$this->modelClass};

		// find and assign list of available option groups
		$this->set(
			'optionGroups',
			$Model->OptionGroup->find('list', [
				'order' => 'OptionGroup.name ASC'
			])
		);
	}

/**
 * Defines the buttons in the toolbar displayed on an admin_form
 *
 * Override in your controller to customise
 *
 * @param int $id ID of the record the form is for.
 * @return array
 */
	protected function _adminFormToolbar($id = null) {
		$formToolbar = parent::_adminFormToolbar($id);

		if (! empty($id)) {
			// fetch the option group id, based on the current items id that will
			// allow us to include a link back to the option group template
			$optionGroupId = $this->{$this->modelClass}->fieldOnly('option_group_id', [
				'id' => $id
			]);

			// add link open up navigation back to the option group template
			$formToolbar['Return to Option Group'] = [
				'class' => 'toolbar__btn--listing',
				'url' => [
					'admin' => true,
					'plugin' => 'ev_shop',
					'controller' => 'option_groups',
					'action' => 'edit',
					$optionGroupId
				]
			];
		}

		return $formToolbar;
	}

/**
 * Determines the redirect URL for admin_edit after saving. Extend in your controller to add
 * additional functionality.
 *
 * @param int $id Primary key.
 * @return array|string Redirect route.
 */
	protected function _adminEditSaveRedirect($id) {
		if (
			empty($this->request->data['return'])
		) {
			//Return back to the option group
			$optionGroupId = $this->{$this->modelClass}->field(
				'option_group_id',
				[
					'id' => $id
				]
			);

			if (!empty($optionGroupId)) {
				return [
					'admin' => true,
					'plugin' => 'ev_shop',
					'controller' => 'option_groups',
					'action' => 'edit',
					$optionGroupId
				];
			}
		}

		return parent::_adminEditSaveRedirect($id);
	}

/**
 * Manages an admin delete for this model.
 *
 * @param int $id ID of row to delete.
 * @return void.
 */
	public function admin_delete($id) {
		//Return back to the option group once deleted
		$optionGroupId = $this->{$this->modelClass}->field(
			'option_group_id',
			[
				'id' => $id
			]
		);

		if (!empty($optionGroupId)) {
			$this->adminRedirect = [
				'admin' => true,
				'plugin' => 'ev_shop',
				'controller' => 'option_groups',
				'action' => 'edit',
				$optionGroupId
			];
		}

		parent::admin_delete($id);
	}
}
