<?php
App::uses('EvShopAppController', 'EvShop.Controller');

class OptionGroupsController extends EvShopAppController {

/**
 * Defines the fields displayed in a filter form.
 * This has been overridden to remove unwanted fields from display.
 *
 * @see EvCore.Controllers/EvCoreController
 * @return array All the filter fields as an array
 */
	protected function _adminFilterFields() {
		$fields = parent::_adminFilterFields();

		unset(
			$fields['OptionGroup.id'],
			$fields['OptionGroup.created'],
			$fields['OptionGroup.modified']
		);

		return $fields;
	}

/**
 * Used to populate form drop down selects
 * Overridden to add in the field types if they are in use
 *
 * @return void
 */
	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		// find and assign list of availale field types if a list exists.
		$fieldTypes = Configure::read('EvShop.optionGroupFieldTypes');

		if (! empty($fieldTypes)) {
			$this->set('fieldTypes', $fieldTypes);
		}
	}

/**
 * Defines the fields displayed in an admin_form for this model
 * Defaults to all fields in the db table but overridden to modify field values
 * and remove unwanted fields.
 *
 * @see EvCore.Controllers/EvCoreController
 * @return array All the form fields we want to use as an array
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['OptionGroup.name']['label'] = 'Option Group Name';

		// Check if there are any option group field types defined in the EvShop config.
		$fieldTypes = Configure::read('EvShop.optionGroupFieldTypes');

		// If the field types array has values, and we've got the field type field, modify it.
		if (! empty($fieldTypes) && isset($fields['OptionGroup.field_type'])) {
			// Set the field type to a select as we've found some options
			$fields['OptionGroup.field_type']['empty'] = false;
			$fields['OptionGroup.field_type']['type'] = 'select';
		} else {
			// No options found so theres no need to show the field as we're not using it.
			unset($fields['OptionGroup.field_type']);
		}

		return $fields;
	}

/**
 * Manages an admin edit form for this model. Overridden to inkect the EvShop Options Helper.
 *
 * @param int $id ID of row to edit.
 * @return void.
 */
	public function admin_edit($id = null) {
		$this->toInject('components', 'EvShop.Options');
		$this->toInject('helpers', 'EvShop.Options');

		parent::admin_edit($id);
	}
}
