<?php

App::uses('EvShopAppController', 'EvShop.Controller');

class GoogleFeedController extends EvShopAppController {

	public $components = array('RequestHandler');

	public $feed = '';

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow('index');
	}

	/**
	 * main method for loading google feed
	 */
	public function index() {
		ini_set('memory_limit', '5000M');
		set_time_limit(0);

		if (Configure::read('EvShop.googleFeed.useFile') !== false) {
			if (!empty(Configure::read('EvShop.googleFeed.filepath'))) {
				if (file_exists(APP . Configure::read('EvShop.googleFeed.filepath'))) {
					$this->feed = file_get_contents(APP . Configure::read('EvShop.googleFeed.filepath'));
				}
			}
		}

		if (empty($this->feed)) {
			$this->feed = $this->_generateFeed();
		}

		$this->response->disableCache();
		$this->response->length(strlen($this->feed));
		$this->response->type('xml');
		$this->response->body($this->feed);

		// output csv
		return $this->response;
	}

/**
 * Generate the google shopping feed.
 *
 * @return xml The generate feed.
 */
	protected function _generateFeed() {
		$feedLib = null;

		// Check for extended lib
		App::uses('EvShopGoogleFeedLib', 'Lib');
		if (class_exists('EvShopGoogleFeedLib')) {
			$feedLib = new EvShopGoogleFeedLib();
		}

		// Fallback on plugin Lib
		if (empty($feedLib)) {
			App::uses('GoogleFeedLib', 'EvShop.Lib');
			$feedLib = new GoogleFeedLib();
		}

		return $feedLib->generate();
	}
}
