<?php
App::uses('AppController', 'Controller');

class EvShopAppController extends AppController {

/**
 * Constructor.
 *
 * @param CakeRequest $request Request object for this controller. Can be null for testing,
 *  but expect that features that use the request parameters will not work.
 * @param CakeResponse $response Response object for this controller.
 */
	public function __construct($request = null, $response = null) {
		/*
		 * There can be issues within the shop when some models have been extended. If a non extended model is
		 * initialised and is related to an extended model, the non extended model is loaded into the object registry.
		 * Once it is loaded the extended version will never get initialised.
		 *
		 * To avoid this EvClassRegistry is used now to load the extended model into the object registry before the non
		 * extended version can be loaded.
		 *
		 * The most frequently extended models are loaded here, if issues occur with other models then they will need
		 * to be loaded like this in the AppController.
		 */
		EvClassRegistry::init('EvShop.Product');
		EvClassRegistry::init('EvShop.Category');

		$this->components[] = 'EvShop.Products';
		$this->components[] = 'EvShop.Categories';
		$this->components[] = 'EvShop.Brands';

		if (CakePlugin::loaded('EvBreadcrumb')) {
			$this->components[] = 'EvBreadcrumb.Breadcrumb';
		}

		if (CakePlugin::loaded('EvCurrency')) {
			$this->components[] = 'EvCurrency.Currencies';
		}

		if (CakePlugin::loaded('EvTax')) {
			$this->components[] = 'EvTax.Taxable';
		}

		if (CakePlugin::loaded('EvInventory')) {
			$this->helpers[] = 'EvInventory.Inventory';
		}

		$this->helpers[] = 'EvShop.Products';
		$this->helpers['EvBreadcrumb.Breadcrumb'] = [];

		parent::__construct($request, $response);
	}

/**
 * Called before the controller action. You can use this method to
 * configure and customize components or perform logic that needs
 * to happen before each controller action.
 *
 * @return void
 */
	public function beforeFilter() {
		parent::beforeFilter();

		// check for Filter form post requests coming from the site, redirecting
		// with a bookmarkable URL
		if (
			$this->request->is('post') &&
			(
				! isset($this->request->params['admin']) ||
				$this->request->params['admin'] !== true
			) &&
			! empty($this->request->data['EvShopFilter'])
		) {
			// Create redirect URL for filters
			$redirect = $this->Products->getRedirectFromFilters(
				$this->request
			);

			// redirect to the bookmarkable filter URL
			$this->redirect($redirect);
		}
	}

	/**
	 * Manages an admin edit form for this model
	 *
	 * @param integer $id ID of row to edit
	 * @return void
	 */
	public function admin_edit($id = null) {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		parent::admin_edit($id);

		$this->set('variantImageSlots', $Model->variantImageSlots);
	}

	/**
	 * Fields used in the Variant edit page
	 */
	protected function _adminVariantManageFields() {
		return array(
			'Variant.id' => array(
				'type' => 'hidden'
			),
			'Variant.sequence' => array(
				'type' => 'hidden',
				'class' => 'sequence-input',
			),
			'Variant.option_desc' => array(
				'type' => 'string',
				'displayonly' => 'displayonly'
			),
			'Variant.name' => array(
				'type' => 'string'
			),
			'Variant.sku' => array(
				'type' => 'string'
			),
			'Variant.is_active' => array(
				'type' => 'boolean'
			)
		);
	}

	/**
	 * given the current category, get the parents for breadcrumbs
	 *
	 * @param 	array 	$category 		The current category
	 * @param 	array 	$categories 	Array of all categories (optional)
	 * @param 	bool 	$isProductPath 	Product Category path, set so we can set the url on first category
	 * @return 	bool
	 */
	protected function _getCategoryParentsBreadcrumb($category, $categories = array(), $isProductPath = false) {
		if (! empty($category['Category']['parent_id'])) {
			$parentId = $category['Category']['parent_id'];

			if (! empty($categories)) {
				$catList = $categories;
			} else {
				$CategoryModel = EvClassRegistry::init('EvShop.Category');
				$catList = $CategoryModel->getBreadcrumbList();
			}

			if (isset($catList[$parentId])) {
				$this->_getCategoryParentsBreadcrumb(
					$catList[$parentId],
					$catList
				);
			}
		}

		$url = null;
		if ((! empty($categories) || $isProductPath === true) && ! empty($category['Category']['id'])) {
			$url = $this->Routable->getItemRoute('EvShop', 'Category');
			$url[] = $category['Category']['id'];
		}

		if (! empty($category['Category']['name'])) {
			$this->Breadcrumb->addCrumb(
				$category['Category']['name'],
				$url
			);
		}

		return true;
	}

	/**
	 * given the product array get the categories breadcrumb
	 *
	 * @param 	array 	$product 	The product array
	 * @return 	bool
	 */
	protected function _getProductBreadcrumb($product) {
		krsort($product['CategoriesProduct']);

		$category = array_shift($product['CategoriesProduct']);

		$this->_getCategoryParentsBreadcrumb($category, array(), true);

		$this->Breadcrumb->addCrumb(
			$product['Product']['name']
		);

		return true;
	}

}
